/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 微信上报信息
 *
 * @author zhaoyi
 * @version WechatInfo.java, v 0.1 2020-07-29 15:25 zhaoyi
 */
@Data
public class WechatReportInfo implements Serializable {

    private static final long serialVersionUID = -6916819711835370195L;

    /**
     * 微信商户号
     */
    private String subMchId;


    /**
     * 微信商户号所属渠道号
     */
    private String channelId;

    /**
     * 上报失败时的失败原因
     */
    private String msg;

    /**
     * 创建时间（商户没有上报则为空）
     */
    private String createTime;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }


}
