/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.pay;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;

/**
 * 条码支付（被扫：B扫C）request
 *
 * @author zhaoyi
 * @version LeshuaScanCardPayRequest.java, v 0.1 2020-07-29 10:50 zhaoyi
 */
@Data
public class LeshuaScanCardPayRequest extends LeshuaBasePayRequest {

    private static final long serialVersionUID = -5373092172567322638L;
    /**
     * 接口名
     * 固定值
     */
    private String service = "upload_authcode";

    /**
     * 付款码
     **/
    @NotBlank(message = "authCode不能为空")
    private String authCode;

    /**
     * 商户号
     * 由乐刷分配
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 商户订单号
     * 商户内部订单号，可以包含字母：确保同一个商户下唯一
     */
    @NotBlank(message = "thirdOrderId不能为空")
    private String thirdOrderId;

    /**
     * 订单金额，以分为单位
     * 总金额（金额不能为零或负数）
     **/
    @NotBlank(message = "amount不能为空")
    private String amount;

    /**
     * 支付宝smid和微信sub_mch_id
     **/
    private String assMerchantId;

    /**
     * 通知地址
     * 接收乐刷通知（支付结果通知）的URL，需做UrlEncode 处理，需要绝对路径，确保乐刷能正确访问，若不需要回调请忽略
     **/
    private String notifyUrl;

    /**
     * 用户IP地址
     * 商户发起交易的IP地址
     **/
    private String clientIp;

    /**
     * 商品描述，不能包含回车换行等特殊字符
     */
    private String body;

    /**
     * 商户门店编号
     */
    private String shopNo;

    /**
     * 商户终端编号
     * 只能是汉字、英文字母、数字
     */
    private String posNo;

    /**
     * 附加数据
     * 下单成功原样返回；注意：只能是汉字、英文字母、数字
     */
    private String attach;

    /**
     * 指定支付方式
     * 1：禁止使用信用卡；0或者不填：不限制
     */
    private String limitPay;

    /**
     * 订单优惠标记，透传给微信
     */
    private String goodsTag;

    /**
     * 商品详情
     * 按微信单品优惠券格式传递透传给微信;请做UrlEncode
     */
    private String goodsDetail;

    /**
     * 支付宝花呗分期数，支持3、6、12期
     */
    private String hbFqNum;

    /**
     * 业务拓展参数
     * 当前可透传支付宝扫码点餐的参数，business_params、goods_detail、extend_params
     */
    private String extendBusinessParams;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
