/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 结算信息
 *
 * @author zhaoyi
 * @version AccountInfo.java, v 0.1 2020-07-27 14:51 zhaoyi
 */
@Data
public class AccountInfo implements Serializable {

    private static final long serialVersionUID = -5204422318614412117L;

    /**
     * 账户类型
     * 1：个人账户
     * 2：公司账户
     */
    @NotNull(message = "账户类型不能为空")
    private Integer type;

    /**
     * 结算标志
     */
    @NotNull(message = "结算标志不能为空")
    private Integer legalFlag;


    /**
     * 开户支行联行号
     */
    @NotBlank(message = "开户支行联行号不能为空")
    @Length(max = 20, message = "开户支行联行号超长")
    private String unionpay;

    /**
     * 开户名；
     * （法人结算：与法人姓名姓名一致；
     * 企业账户：与营业执照注册名称一致）
     */
    @NotBlank(message = "开户名不能为空")
    private String holder;

    /**
     * 结算人证件(个人账户必传，非法人结算只能是身份证)，法人结算与法人证件号一致
     */
    @Length(max = 18, message = "结算人证件超长")
    private String idCardNo;

    /**
     * 结算人证件类型（与法人证件参数相同，默认身份证）
     */
    @Length(max = 1, message = "结算人证件类型错误")
    private String idCardType;

    /**
     * 银行预留号码
     */
    @Length(max = 11, message = "银行预留号码超长")
    private String mobile;

    /**
     * 银行卡号
     */
    @NotBlank(message = "银行卡号不能为空")
    @Length(max = 24, message = "银行卡号超长")
    private String bankCardNo;

    /**
     * 银行卡正面（如是对公账户，开户许可证）图片地址
     */
    @NotBlank(message = "银行卡正面图片地址不能为空")
    private String bankCardFrontPic;

    /**
     * 非法人结算授权书(非法人结算模式必传)
     */
    private String nonLegSettleAuthPic;

    /**
     * 非法人身份证正面(非法人结算模式必传)
     */
    private String nonLegIdcardFrontPic;

    /**
     * 非法人身份证背面(非法人结算模式必传)
     */
    private String nonLegIdcardBackPic;
}
