/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商户微信实名认证-申请request
 *
 * @author zhaoyi
 * @version MerchantWxApplyRequest.java, v 0.1 2020-07-29 14:50 zhaoyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantWxApplyRequest extends LeshuaBizRequest<LeshuaBaseResponse> {

    /**
     * 商户编号
     */
    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;

    /**
     * 枚举值说明：
     * 门店场所：MICRO_TYPE_STORE
     * 流动经营/便民服务：MICRO_TYPE_MOBILE
     * 线上商品/服务交易：MICRO_TYPE_ONLINE
     */
    private Integer microBizType;


    @Override
    public Class<LeshuaBaseResponse> getResponseClass() {
        return LeshuaBaseResponse.class;
    }

}
