/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author youmingming
 * @version LeshuaSettlementApiEnum.java, v 0.1 2020-11-02 8:31 下午 youmingming
 */
public enum LeshuaSettlementApiEnum {
    /**
     * 结算接口
     */
    API_SETTLEMENT_ORDER("商户打款单结果查询", "/open-api/agent/settlement-order"),
    API_MERCHANT_DATE_SETTLEMENT_ORDER("查询商户指定日期打款情况", "/open-api/agent/merchant-settlement-order"),
    API_AGENT_FAIL_SETTLEMENT_ORDER("查询旗下商户打款失败明细", "/open-api/agent/agent-fail-settlement-order");

    private String name;
    private String value;

    LeshuaSettlementApiEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static LeshuaSettlementApiEnum getByValue(String value) {
        LeshuaSettlementApiEnum[] valueList = LeshuaSettlementApiEnum.values();
        for (LeshuaSettlementApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}