/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fshows.leshuapay.sdk.client.LeshuaBasicClient;
import com.fshows.leshuapay.sdk.request.basic.BankBranchRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import com.fshows.leshuapay.sdk.response.basic.BankBranch;
import com.fshows.leshuapay.sdk.response.basic.BankBranchListResponse;
import com.fshows.leshuapay.sdk.util.FsHttpUtil;
import com.fshows.leshuapay.sdk.util.ReqSerialNoUtil;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;


/**
 * @author zhaoyi
 * @version LeshuaBasicClientImpl.java, v 0.1 2020-07-28 08:50 AM zhaoyi
 */
@Slf4j
@Data
public class LeshuaBasicClientImpl<Req, Res> implements LeshuaBasicClient<Req, Res> {

    /**
     * 服务地址
     */
    private String serverUrl;

    /**
     * 服务商标识
     */
    private String agentId;

    public LeshuaBasicClientImpl(String serverUrl, String agentId) {
        this.serverUrl = serverUrl;
        this.agentId = agentId;
    }

    @Override
    public LeshuaBaseResponse<List<Res>> execute(Req request, Class<Res> resClass, String url) {
        LeshuaBaseResponse<List<Res>> response = new LeshuaBaseResponse<>();
        String reqSerialNo = ReqSerialNoUtil.getReqSerialNo();
        Map<String, String> requestMap = new ConcurrentSkipListMap<>();
        requestMap.put("agentId", agentId);
        requestMap.put("reqSerialNo", reqSerialNo);
        requestMap.put("data", JSON.toJSONString(request));
        try {
            String responseStr = FsHttpUtil.post(serverUrl + url, requestMap);
            JSONObject jsonObject = JSON.parseObject(responseStr);
            response.setReqSerialNo(jsonObject.getString("reqSerialNo"));
            response.setRespCode(jsonObject.getString("respCode"));
            response.setRespMsg(jsonObject.getString("respMsg"));
            response.setVersion(jsonObject.getString("version"));
            JSONArray jsonArray = jsonObject.getJSONArray("data");
            List<Res> resList = jsonArray.toJavaList(resClass);
            response.setData(resList);
            return response;
        } catch (IOException e) {
            log.error("执行http请求异常,e={}", ExceptionUtils.getStackTrace(e));
        }
        return response;
    }

    @Override
    public LeshuaBaseResponse<BankBranchListResponse> queryBankBranch(BankBranchRequest request, String url) {
        LeshuaBaseResponse<BankBranchListResponse> response = new LeshuaBaseResponse<>();
        String reqSerialNo = ReqSerialNoUtil.getReqSerialNo();
        Map<String, String> requestMap = new ConcurrentSkipListMap<>();
        requestMap.put("agentId", agentId);
        requestMap.put("reqSerialNo", reqSerialNo);
        requestMap.put("data", JSON.toJSONString(request));
        try {
            String responseStr = FsHttpUtil.post(serverUrl + url, requestMap);
            JSONObject jsonObject = JSON.parseObject(responseStr);
            response.setReqSerialNo(jsonObject.getString("reqSerialNo"));
            response.setRespCode(jsonObject.getString("respCode"));
            response.setRespMsg(jsonObject.getString("respMsg"));
            response.setVersion(jsonObject.getString("version"));
            JSONObject dataJson = jsonObject.getJSONObject("data");
            BankBranchListResponse bankBranchListResponse = new BankBranchListResponse();
            bankBranchListResponse.setTotal(dataJson.getInteger("total"));
            JSONArray jsonArray = dataJson.getJSONArray("list");
            List<BankBranch> bankBranches = jsonArray.toJavaList(BankBranch.class);
            bankBranchListResponse.setList(bankBranches);
            response.setData(bankBranchListResponse);
            return response;
        } catch (IOException e) {
            log.error("执行http请求异常,e={}", ExceptionUtils.getStackTrace(e));
        }
        return response;
    }
}
