/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lakala.client.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.LakalaHttpResult;
import com.fshows.lakala.client.base.VerifySignParam;
import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.util.FsHttpResult;
import com.fshows.lakala.util.FsHttpUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultHttpRequestImpl
implements IHttpRequest {
    @Override
    public LakalaHttpResult post(String url, String authorization, String requestBody, ApiClientConfig apiClientConfig) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", authorization);
        if (url.endsWith(LakalaTradeApiDefinitionEnum.BANK_PAY_ORDER_QUERY.getApiSubURI())) {
            headers.put("Accept", "*/*");
        }
        headers.put("Accept-Encoding", "indentity");
        FsHttpResult fsHttpResult = FsHttpUtil.postStringWithResult(url, requestBody, apiClientConfig.getCharset(), "application/json;charset=utf-8", apiClientConfig.getConnectionTimeout(), apiClientConfig.getReadTimeout(), headers);
        if (fsHttpResult != null) {
            return this.convertLakalaHttpResult(fsHttpResult);
        }
        return null;
    }

    private LakalaHttpResult convertLakalaHttpResult(FsHttpResult fsHttpResult) {
        LakalaHttpResult lakalaHttpResult = new LakalaHttpResult();
        lakalaHttpResult.setBody(fsHttpResult.getResBody());
        Map<String, List<String>> headList = fsHttpResult.getResHeader();
        if (CollectionUtil.isNotEmpty(headList)) {
            VerifySignParam verifySignParam = new VerifySignParam();
            verifySignParam.setAppid(this.getHeadFeild("Lklapi-Appid", headList));
            verifySignParam.setSerialNo(this.getHeadFeild("Lklapi-Serial", headList));
            verifySignParam.setNonceStr(this.getHeadFeild("Lklapi-Nonce", headList));
            String timestampStr = this.getHeadFeild("Lklapi-Timestamp", headList);
            Long timeStamp = StringUtils.isBlank((CharSequence)timestampStr) ? null : new Long(timestampStr);
            verifySignParam.setTimeStamp(timeStamp);
            verifySignParam.setSign(this.getHeadFeild("Lklapi-Signature", headList));
            lakalaHttpResult.setVerifySignParam(verifySignParam);
            lakalaHttpResult.setLakalaTraceId(this.getHeadFeild("Lklapi-Traceid", headList));
        }
        return lakalaHttpResult;
    }

    private String getHeadFeild(String key, Map<String, List<String>> headList) {
        if (headList == null) {
            return null;
        }
        List<String> valueList = headList.get(key);
        if (CollectionUtil.isEmpty(valueList)) {
            return null;
        }
        return valueList.get(0);
    }
}

