/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.pay.accbusifields.alipay;

import com.fshows.lakala.request.trade.pay.accbusifields.BaseAccBusiFieldsRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 支付宝二维码被扫场景下acc_busi_fields域内容
 *
 * @author liluqing
 * @version AlipayScanCardAccBusiRequest.java, v 0.1 2022-03-07 13:32
 */
@Data
public class AlipayScanCardAccBusiRequest extends BaseAccBusiFieldsRequest {

    private static final long serialVersionUID = -7194184331322449436L;
    /**
     * 业务扩展参数 (选填)
     * 支付宝业务扩展参数 ，主要用于花呗分期，见extend_params字段说明
     */
    private AlipayExtendParamsRequest extendParams;

    /**
     * 商户传入业务信息 (选填)
     * 商户传入业务信息，应用于安全，营销 等参数直传场景，格式为 json 格式。
     */
    @Length(max = 512, message = "商户传入业务信息长度不能超过512")
    private String businessParams;

    /**
     * 商品详情 (选填)
     * 订单包含的商品列表信息，Json格式。见“支付宝goods_detail字段说明”
     */
    @Length(max = 6000, message = "商品详情长度不能超过6000")
    private String goodsDetail;

    /**
     * 支付宝店铺编号 (选填)
     * 支付宝收单上送
     */
    @Length(max = 32, message = "支付宝店铺编号长度不能超过32")
    private String alipayStoreId;

    /**
     * 交易有效时间（待上线） (选填)
     * 订单的有效时间，以分钟为单位。如果在有效时间内没有完成付款，则在账户端该订单失效。如果不上送，以账户端订单失效时间为准。 建议不超过15分钟。不传值则默认5分钟。
     */
    @Length(max = 2, message = "交易有效时间（待上线）长度不能超过2")
    private String timeoutExpress;

    /**
     * 支付宝禁用支付渠道 (选填)
     * “credit_group”表示禁用信用卡
     */
    @Length(max = 32, message = "支付宝禁用支付渠道长度不能超过32")
    private String disablePayChannels;

    /**
     * 	优惠明细参数，通过此属性补充营销参数
     */
    private AlipayPromoParams promoParams;
}