package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaRateChangeFeeResponse;
import lombok.Data;

import java.util.Set;

/**
 * @author liangyuanping
 * @version LakalaRateChangeFeeRequest.java, v 0.1 2023-02-22 3:23 PM
 */
@Data
public class LakalaRateChangeFeeRequest extends LakalaBizRequest<LakalaRateChangeFeeResponse, LakalaMerchantApiDefinitionEnum> {
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 订单编号（便于后续跟踪排查问题及核对报文）	接入方编码+14位年月日时（24小时制）分秒+8位的随机数（不重复）如：2021020112000012345678
     */
    private String orderNo;
    /**
     * 机构代码
     */
    private String orgCode;
    /**
     * 商户内部商户号(拉卡拉内部商户号和银联商户号必须传一个，都送以内部商户号为准)	4002019111800000020
     */
    private String merInnerNo;
    /**
     * 银联商户号	82229005411000A
     */
    private String merCupNo;
    /**
     * 银联终端号
     */
    private String termNo;
    /**
     * 回调地址
     */
    private String retUrl;
    /**
     * 附件信息集合
     */
    private Set<LakalaFileDataRequest> fileData;
    /**
     * 费率信息集合
     */
    private Set<LakalaFeeRateRequest> feeData;
    /**
     * 外卡费率集合
     */
    private Set<LakalaForeignCardFeeRequest> foreignCardFeeList;
}