package com.fshows.lakala.request.activity;

import com.fshows.lakala.enums.activity.LakalaActivityApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.activity.LakalaActivityPackageQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

@Data
public class LakalaActivityPackageQueryRequest extends LakalaBizRequest<LakalaActivityPackageQueryResponse, LakalaActivityApiDefinitionEnum> {

    /**
     * 商户号 （822商户号）
     */
    @Length(max = 32, message = "业主方id长度不能超过8")
    private String merchantNo;
    /**
     * 开始时间 yyyyMMddHHmmss
     */
    private String startTime;
    /**
     * 结束时间 yyyyMMddHHmmss
     */
    private String endTime;
    /**
     * 页码
     */
    private Integer page;
    /**
     * 每页数量 最大10
     */
    private String size;

}
