/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.pay;

import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.response.trade.accbusifields.LakalaScanCardAccBusiResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 被扫交易响应
 *
 * @author liluqing
 * @version LakalaScanCardResponse.java, v 0.1 2022-03-07 13:42
 */
@Data
public class LakalaScanCardResponse extends LakalaBizResponse {

    private static final long serialVersionUID = 7150571285451070291L;

    /**
     * 是否需要发起查询 (必填参数)
     * 0=不需要 1=需要 当返回1时，代表订单处理中，商户需主动发起查询
     */
    @NotBlank
    @Length(max = 32, message = "是否需要发起查询长度不能超过32")
    private String needQuery;

    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号（请求接口中商户号）
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 商户交易流水号 (必填参数)
     * 请求报文中的商户交易流水号
     */
    @NotBlank
    @Length(max = 32, message = "商户交易流水号长度不能超过32")
    private String outTradeNo;

    /**
     * 拉卡拉交易流水号 (必填参数)
     * 拉卡拉交易流水号
     */
    @NotBlank
    @Length(max = 32, message = "拉卡拉交易流水号长度不能超过32")
    private String tradeNo;

    /**
     * 拉卡拉对账单流水号 (必填参数)
     * 拉卡拉对账单流水号
     */
    @NotBlank
    @Length(max = 14, message = "拉卡拉对账单流水号长度不能超过14")
    private String logNo;

    /**
     * 账户端交易订单号 (选填)
     * 账户端交易流水号
     */
    @Length(max = 32, message = "账户端交易订单号长度不能超过32")
    private String accTradeNo;

    /**
     * 钱包类型 (必填参数)
     * 微信：WECHAT 支付宝：ALIPAY 银联：UQRCODEPAY 翼支付: BESTPAY 苏宁易付宝: SUNING 数字货币：DCPAY
     */
    @NotBlank
    @Length(max = 16, message = "钱包类型长度不能超过16")
    private String accountType;

    /**
     * 订单金额 (必填参数)
     * 单位分，整数数字型字符 订单金额=付款人实际发生金额+商户优惠金额+账户端优惠金额
     */
    @NotBlank
    @Length(max = 12, message = "订单金额长度不能超过12")
    private String totalAmount;

    /**
     * 付款人实际发生金额 (必填参数)
     *
     */
    @NotBlank
    @Length(max = 12, message = "付款人实际发生金额长度不能超过12")
    private String payerAmount;

    /**
     * 账户端应结订单金额 (必填参数)
     * 应结订单金额，单位分 ，账户端应结订单金额=付款人实际发生金额+账户端优惠金额
     */
    @NotBlank
    @Length(max = 12, message = "账户端应结订单金额长度不能超过12")
    private String accSettleAmount;

    /**
     * 商户优惠金额（账户端） (选填)
     * 账户端返回商户优惠金额，单位分
     */
    @Length(max = 12, message = "商户优惠金额（账户端）长度不能超过12")
    private String accMdiscountAmount;

    /**
     * 账户端优惠金额 (选填)
     * 账户端返回账户端优惠金额，单位分
     */
    @Length(max = 12, message = "账户端优惠金额长度不能超过12")
    private String accDiscountAmount;

    /**
     * 交易完成时间 (必填参数)
     * 以账户端返回时间为准
     */
    @NotBlank
    @Length(max = 14, message = "交易完成时间长度不能超过14")
    private String tradeTime;

    /**
     * 付款银行 (选填)
     * 付款银行
     */
    @Length(max = 128, message = "付款银行长度不能超过128")
    private String bankType;

    /**
     * 银行卡类型 (选填)
     * 00：借记 01：贷记 02：微信零钱 03：支付宝花呗 04：支付宝其他 05：数字货币 06：拉卡拉支付账户 99：未知
     */
    @Length(max = 16, message = "银行卡类型长度不能超过16")
    private String cardType;

    /**
     * 备注 (选填)
     *
     */
    @Length(max = 128, message = "备注长度不能超过128")
    private String remark;

    /**
     * 账户端返回信息域 (选填)
     * 账户端返回信息域
     */
    private LakalaScanCardAccBusiResponse accRespFields;
}