package com.fshows.lakala.request.activity;

import com.fshows.lakala.enums.activity.LakalaActivityApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.activity.LakalaActivityApplyQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author liangyuanping
 * @version LakalaActivityApplyRequest.java, v 0.1 2023-02-23 9:47 AM
 * http://open.lakala.com/#/home/document/detail?title=%E6%96%B0%E5%A2%9E%E6%8A%A5%E5%90%8D&id=457
 */
@Data
public class LakalaActivityApplyQueryRequest extends LakalaBizRequest<LakalaActivityApplyQueryResponse, LakalaActivityApiDefinitionEnum> {

    /**
     * 业主方id (必填参数)
     */
    @NotBlank
    @Length(max = 8, message = "业主方id长度不能超过8")
    private String ownerId;

    /**
     * 报名记录Id (必填参数)
     */
    @NotBlank
    @Length(max = 20, message = "报名记录Id长度不能超过20")
    private String enrollId;
}