/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.order;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

/**
 * 订单关单响应
 *
 * @author liluqing
 * @version LakalaCloseResponse.java, v 0.1 2022-03-07 14:04
 */
@Data
public class LakalaCloseResponse extends LakalaBizResponse {

    private static final long serialVersionUID = -1907944764997989972L;
    /**
     * 原拉卡拉订单号 (必填参数)
     */
    private String originTradeNo;

    /**
     * 原商户请求流水号 (必填参数)
     */
    private String originOutTradeNo;

    /**
     * 原订单外部订单来源 (选填)
     */
    private String originOutOrderSource;

    /**
     * 原订单外部商户订单号 (选填)
     */
    private String originOutOrderNo;

    /**
     * 交易时间 (必填参数)
     * 账户端交易时间yyyyMMddHHmmss
     */
    private String tradeTime;

}