/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaQuerySubMerchantResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author zhubo
 * @version LakalaQuerySubMerchantRequest.java, v 0.1 2023-02-17 9:30 zhubo
 */
@Data
public class LakalaQuerySubMerchantRequest extends LakalaBizRequest<LakalaQuerySubMerchantResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = -3891951351181305662L;

    /**
     * 接口版本号 (必填参数)
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构代码 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "机构代码长度不能超过32")
    private String orgCode;

    /**
     * 拉卡拉内部商户号
     */
    @Length(max = 32, message = "拉卡拉内部商户号长度不能超过32")
    private String merInnerNo;

    /**
     * 银联商户号
     */
    @Length(max = 32, message = "银联商户号长度不能超过32")
    private String merCupNo;

    /**
     * 报备渠道
     */
    @Length(max = 8, message = "报备渠道长度不能超过8")
    private String registerChannel;

    /**
     * 报备类型
     */
    @Length(max = 64, message = "报备类型长度不能超过64")
    private String registerType;

    /**
     * 报备状态
     */
    @Length(max = 64, message = "报备状态长度不能超过64")
    private String registerStatus;

    /**
     * 子商户号
     */
    @Length(max = 64, message = "子商户号长度不能超过64")
    private String subMchId;
}
