package com.fshows.lakala.request.activity;

import com.fshows.lakala.enums.activity.LakalaActivityApiDefinitionEnum;
import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.activity.LakalaActivityApplyResponse;
import com.fshows.lakala.response.merchant.LakalaWechatRealNameQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author liangyuanping
 * @version LakalaActivityApplyRequest.java, v 0.1 2023-02-23 9:47 AM
 * http://open.lakala.com/#/home/document/detail?title=%E6%96%B0%E5%A2%9E%E6%8A%A5%E5%90%8D&id=457
 */
@Data
public class LakalaActivityApplyRequest extends LakalaBizRequest<LakalaActivityApplyResponse, LakalaActivityApiDefinitionEnum> {

    /**
     * 业主方id (必填参数)
     */
    @NotBlank
    @Length(max = 8, message = "业主方id长度不能超过8")
    private String ownerId;

    /**
     * 活动id (必填参数)
     */
    @NotBlank
    @Length(max = 20, message = "活动id长度不能超过20")
    private String activityId;

    /**
     * 商户号 (必填参数)
     */
    @NotBlank
    @Length(max = 15, message = "商户号长度不能超过15")
    private String merNo;

    /**
     *  政策编号
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String templetId;

    /**
     * 头寸编号
     */
    @NotBlank
    @Length(max = 32, message = "头寸长度不能超过32")
    private String expenseAccount;
    /**
     * 推荐人
     * 示例：20220524000000
     */
    @Length(max = 64, message = "推荐人长度不能超过64")
    private String referral;

    /**
     * 商户mcc(用于校验是否允许参与报名)
     */
    @Length(max = 64, message = "商户mcc长度不能超过64")
    private String mcc;

    /**
     * 商户地区市(用于校验是否允许参与报名)
     */
    @Length(max = 64, message = "商户地区市长度不能超过64")
    private String regionCity;

    /**
     * 商户地区省(用于校验是否允许参与报名)
     */
    @Length(max = 64, message = "商户地区省长度不能超过64")
    private String regionProvince;

    /**
     * 商户所属机构
     */
    @Length(max = 16, message = "商户所属机构长度不能超过16")
    private String orgNo;

    /**
     * 结算卡卡bin
     */
    @Length(max = 16, message = "结算卡卡bin长度不能超过16")
    private String cardBin;
}