/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.order;

import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.response.trade.accbusifields.LakalaOrderQueryAccBusiResponse;
import com.fshows.lakala.response.trade.info.LakalaBankPayOrderInfoResponse;
import com.fshows.lakala.response.trade.info.LakalaBankPayOrderOutSplitInfoResponse;
import com.fshows.lakala.response.trade.info.LakalaBankPayOrderSplitInfoResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 刷卡订单查询接口
 *
 * @author wangyi
 * @version LakalaBankPayOrderQueryResponse.java, v 0.1 2022-03-04 17:23
 */
@Data
public class LakalaBankPayOrderQueryResponse extends LakalaBizResponse {

    private static final long serialVersionUID = 3944609549787663439L;

    /**
     * 支付订单号
     */
    private String payOrderNo;

    /**
     * 商户订单号
     */
    private String outOrderNo;

    /**
     * 渠道号
     */
    private String channelId;

    /**
     * 交易商户号
     */
    private String transMerchantNo;

    /**
     * 交易终端号
     */
    private String transTermNo;

    /**
     * 结算商户号（合单订单中该结算商户号为主单名义上结算商户号）
     */
    private String merchantNo;

    /**
     * 结算终端号（合单订单中该结算商户号为主单名义上结算终端号）
     */
    private String termNo;

    /**
     * 订单状态 (必传参数)
     * 0:待支付 1:支付中 2:支付成功 3:支付失败 4:已过期 5:已取消 6：部分退款或者全部退款 7:已关单
     */
    private String orderStatus;

    /**
     * 订单描述
     */
    private String orderInfo;

    /**
     * 订单金额，单位：分
     */
    private Long totalAmount;

    /**
     * 订单创建时间 格式yyyyMMddHHmmss
     */
    private String orderCreateTime;

    /**
     * 订单有效时间 格式yyyyMMddHHmmss
     */
    private String orderEfficientTime;

    /**
     * 结算类型（非合单） （“0”或者空，常规结算方式）
     */
    private String settleType;

    /**
     * 合单标识 “1”为合单，不填默认是为非拆单
     */
    private String splitMark;

    /**
     * 商户拆单信息
     */
    private List<LakalaBankPayOrderOutSplitInfoResponse> outSplitInfo;

    /**
     * 交易拆单信息
     */
    private List<LakalaBankPayOrderSplitInfoResponse> splitInfo;

    /**
     * 订单交易信息列表
     */
    private List<LakalaBankPayOrderInfoResponse> orderTradeInfoList;
}