/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.order;

import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.request.trade.pay.LakalaLocationInfoRequest;
import com.fshows.lakala.response.trade.order.LakalaRevokeResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 订单撤销
 *
 * @author liluqing
 * @version LakalaRevokeRequest.java, v 0.1 2022-03-07 13:58
 */
@Data
public class LakalaRevokeRequest extends LakalaBizRequest<LakalaRevokeResponse, LakalaTradeApiDefinitionEnum> {

    private static final long serialVersionUID = -4786193894571328930L;

    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 终端号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "终端号长度不能超过32")
    private String termNo;

    /**
     * 商户交易流水号 (必填参数)
     * 商户系统唯一
     */
    @NotBlank
    @Length(max = 32, message = "商户交易流水号长度不能超过32")
    private String outTradeNo;

    /**
     * 原商户交易流水号 (选填)
     * 下单时的商户请求流水号（撤销时origin_out_trade_no，origin_trade_no必送其一）
     */
    @Length(max = 32, message = "原商户交易流水号长度不能超过32")
    private String originOutTradeNo;

    /**
     * 原拉卡拉交易流水号 (选填)
     * 下单成功时，返回的拉卡拉交易流水。
     */
    @Length(max = 32, message = "原拉卡拉交易流水号长度不能超过32")
    private String originTradeNo;

    /**
     * 地址位置信息 (必填参数)
     * 地址位置信息，风控要求必送
     */
    @NotNull
    private LakalaLocationInfoRequest locationInfo;

}