package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaTerminalDetailResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 设备详情请求
 *
 */
@Data
public class LakalaTerminalDetailRequest extends LakalaBizRequest<LakalaTerminalDetailResponse, LakalaMerchantApiDefinitionEnum> {

    /**
     * 接口版本号 (必填参数)
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构代码 (必填参数)
     */

    private String merInnerNo;

    /**
     * 银联商户号
     */

    private String merCupNo;


    /**
     * 终端号
     */
    @NotBlank
    @Length(max = 32, message = "终端号不能超过10")
    private String termNo;

}
