package com.fshows.lakala.enums.activity;

import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.request.activity.LakalaActivityApplyQueryRequest;
import com.fshows.lakala.request.activity.LakalaActivityApplyRequest;
import com.fshows.lakala.request.settle.*;
import com.fshows.lakala.response.activity.LakalaActivityApplyQueryResponse;
import com.fshows.lakala.response.activity.LakalaActivityApplyResponse;
import com.fshows.lakala.response.settle.*;

/**
 * 拉卡拉结算相关API
 *
 * @author liluqing
 * @version LakalaSettleApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum LakalaActivityApiDefinitionEnum implements ILakalaApiDefinition {
    APPLY(
            "新增报名",
            "api/v3/lama/mgt/activity_enroll_insert",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaActivityApplyRequest.class,
            LakalaActivityApplyResponse.class
    ),
    APPLY_QUERY(
            "报名详情",
            "api/v3/lama/mgt/activity_enroll_query_one",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaActivityApplyQueryRequest.class,
            LakalaActivityApplyQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求Class类型
     */
    private Class requestClass;
    /**
     * 响应Class类型
     */
    private Class responseClass;


    LakalaActivityApiDefinitionEnum(String name,
                                    String apiSubURI,
                                    String version,
                                    Class requestClass,
                                    Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}