/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.pay.accbusifields.wx;

import com.fshows.lakala.request.trade.pay.accbusifields.BaseAccBusiFieldsRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 微信二维码被扫场景下acc_busi_fields域内容
 *
 * @author liluqing
 * @version AlipayScanCardAccBusiRequest.java, v 0.1 2022-03-07 13:32
 */
@Data
public class WxScanCardAccBusiRequest extends BaseAccBusiFieldsRequest {

    private static final long serialVersionUID = -5863745482883157415L;
    /**
     * 子商户公众账号ID sub_appid (选填)
     * 微信公众平台基本配置中的AppID(应用ID)，传入后支付成功可返回对应公众号下的用户openid，只对微信支付有效
     */
    @Length(max = 32, message = "子商户公众账号ID sub_appid长度不能超过32")
    private String subAppid;

    /**
     * 商品详情 (选填)
     * 单品优惠功能字段，json字符串格式，内容见以下“微信detail字段说明”
     */
    @Length(max = 1024, message = "商品详情长度不能超过1024")
    private String detail;

    /**
     * 订单优惠标记 (选填)
     * 订单优惠标记，微信平台配置的商品标记，用于优惠券或者满减使用，accountType为WECHAT时，可选填此字段
     */
    @Length(max = 32, message = "订单优惠标记长度不能超过32")
    private String goodsTag;

    /**
     * 设备号 (选填)
     * 终端设备号(门店号或收银设备ID)，注意：PC网页或JSAPI支付请传”WEB”
     */
    @Length(max = 32, message = "设备号长度不能超过32")
    private String deviceInfo;

    /**
     * 指定支付方式 (选填)
     * no_credit–指定不能使用信用卡支付
     */
    @Length(max = 20, message = "指定支付方式长度不能超过20")
    private String limitPay;
}