/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.pay;

import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.request.trade.pay.accbusifields.BaseAccBusiFieldsRequest;
import com.fshows.lakala.response.trade.pay.LakalaScanCardResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 被扫交易下单
 *
 * @author liluqing
 * @version LakalaScanCardRequest.java, v 0.1 2022-03-07 13:01
 */
@Data
public class LakalaScanCardRequest extends LakalaBizRequest<LakalaScanCardResponse, LakalaTradeApiDefinitionEnum> {

    private static final long serialVersionUID = 6408296460047695728L;
    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 终端号 (必填参数)
     * 拉卡拉分配的业务终端号
     */
    @NotBlank
    @Length(max = 32, message = "终端号长度不能超过32")
    private String termNo;

    /**
     * 商户交易流水号 (必填参数)
     * 商户系统唯一，不可重复
     */
    @NotBlank
    @Length(max = 32, message = "商户交易流水号长度不能超过32")
    private String outTradeNo;

    /**
     * 支付授权码 (必填参数)
     * 扫码支付授权码，设备读取用户APP中的条码或者二维码信息，用户付款码条形码规则见说明
     */
    @NotBlank
    @Length(max = 32, message = "支付授权码长度不能超过32")
    private String authCode;

    /**
     * 金额 (必填参数)
     * 单位分，整数型字符
     */
    @NotBlank
    @Length(max = 12, message = "金额长度不能超过12")
    private String totalAmount;

    /**
     * 地址位置信息 (必填参数)
     * 地址位置信息，风控要求必送
     */
    @NotNull
    private LakalaLocationInfoRequest locationInfo;

    /**
     * 业务模式 (选填)
     * 业务模式： ACQ-收单 PAY-付款 不填，默认为“ACQ-收单”
     */
    @Length(max = 8, message = "业务模式长度不能超过8")
    private String busiMode;

    /**
     * 订单标题 (选填)
     * 标题，用于简单描述订单或商品（账户端控制，实际最多42个字符），微信支付必送。
     */
    @Length(max = 42, message = "订单标题长度不能超过42")
    private String subject;

    /**
     * 拉卡拉支付业务订单号 (选填)
     * 拉卡拉订单系统订单号，以拉卡拉支付业务订单号为驱动的支付行为，需上传该字段。 订单交易下单，交易时上送订单系统订单号，交易流程中会校验有效性、判重
     */
    @Length(max = 64, message = "拉卡拉支付业务订单号长度不能超过64")
    private String payOrderNo;

    /**
     * 商户通知地址 (选填)
     * 商户通知地址，如上传，且 pay_order_no 不存在情况下，且支付响应报文是交易中状态的场景下，则按此地址通知商户
     */
    @Length(max = 128, message = "商户通知地址长度不能超过128")
    private String notifyUrl;

    /**
     * 结算类型 (选填)
     * “0”或者空，常规结算方式；
     */
    @Length(max = 4, message = "结算类型长度不能超过4")
    private String settleType;

    /**
    * 备注
    */
    @Length(max = 128, message = "备注长度不能超过128")
    private String remark;

    /**
     * 扫码类型 (选填)
     * 0或不填：扫码支付 1：刷脸支付
     */
    @Length(max = 1, message = "扫码类型长度不能超过1")
    private String scanType;

    /**
     * 身份信息 (选填)
     * 实名支付信息，json字符串，如{“identityNo”:”32000000000000000X”,”name”:”张三”} ，然后国密sm2加密
     */
    @Length(max = 1024, message = "身份信息长度不能超过1024")
    private String identityInfo;

    /**
     * 营销信息 (选填)
     * 拉卡拉优惠相关信息，JSON格式。暂不支持
     */
    @Length(max = 1024, message = "营销信息长度不能超过1024")
    private String promoInfo;

    /**
     * 账户端业务信息域 (选填)
     * 参见以下acc_busi_fields字段详细说明,不同类型的auth_code对应不同的账户端，需要填写不同的信息
     *
     * @see com.fshows.lakala.request.trade.pay.accbusifields.alipay.AlipayScanCardAccBusiRequest
     * @see com.fshows.lakala.request.trade.pay.accbusifields.wx.WxScanCardAccBusiRequest
     * @see com.fshows.lakala.request.trade.pay.accbusifields.union.UnionScanCardAccBusiRequest
     */
    private BaseAccBusiFieldsRequest accBusiFields;
}