/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.client.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.LakalaHttpResult;
import com.fshows.lakala.client.base.VerifySignParam;
import com.fshows.lakala.constant.CommonConstant;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.util.FsHttpResult;
import com.fshows.lakala.util.FsHttpUtil;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * http请求实现类
 *
 * @author liluqing
 * @version DefaultHttpRequest.java, v 0.1 2022-03-02 18:19
 */
public class DefaultHttpRequestImpl implements IHttpRequest {

    @Override
    public LakalaHttpResult post(String url, String authorization, String requestBody, ApiClientConfig apiClientConfig) throws IOException {
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", authorization);
        // 银行卡订单查询特殊处理
        if (url.endsWith(LakalaTradeApiDefinitionEnum.BANK_PAY_ORDER_QUERY.getApiSubURI())) {
            headers.put("Accept", "*/*");
        }
        FsHttpResult fsHttpResult = FsHttpUtil.postStringWithResult(
                url,
                requestBody,
                apiClientConfig.getCharset(),
                CommonConstant.JSON_CONTENT_TYPE,
                apiClientConfig.getConnectionTimeout(),
                apiClientConfig.getReadTimeout(),
                headers);
        if (fsHttpResult != null) {
            return convertLakalaHttpResult(fsHttpResult);
        }
        return null;
    }

    /**
     * fsHttpResult 转>> LakalaHttpResult
     *
     * @param fsHttpResult
     * @return
     */
    private LakalaHttpResult convertLakalaHttpResult(FsHttpResult fsHttpResult) {
        LakalaHttpResult lakalaHttpResult = new LakalaHttpResult();
        lakalaHttpResult.setBody(fsHttpResult.getResBody());

        Map<String, List<String>> headList = fsHttpResult.getResHeader();
        if (CollectionUtil.isNotEmpty(headList)) {
            VerifySignParam verifySignParam = new VerifySignParam();
            verifySignParam.setAppid(getHeadFeild(LakalaConstant.HTTP_RESPONSE_HEADER_APPID, headList));
            verifySignParam.setSerialNo(getHeadFeild(LakalaConstant.HTTP_RESPONSE_HEADER_SERIAL, headList));
            verifySignParam.setNonceStr(getHeadFeild(LakalaConstant.HTTP_RESPONSE_HEADER_NONCE, headList));
            String timestampStr = getHeadFeild(LakalaConstant.HTTP_RESPONSE_HEADER_TIMESTAMP, headList);
            Long timeStamp = StringUtils.isBlank(timestampStr) ? null : new Long(timestampStr);
            verifySignParam.setTimeStamp(timeStamp);
            verifySignParam.setSign(getHeadFeild(LakalaConstant.HTTP_RESPONSE_HEADER_SIGN, headList));
            lakalaHttpResult.setVerifySignParam(verifySignParam);
            // 设置traceId
            lakalaHttpResult.setLakalaTraceId(getHeadFeild(LakalaConstant.HTTP_RESPONSE_HEADER_TRACEID, headList));
        }
        return lakalaHttpResult;
    }

    /**
     * 从headList中获取具体某个key值
     *
     * @param key
     * @param headList
     * @return
     */
    private String getHeadFeild(String key, Map<String, List<String>> headList) {
        if (headList == null) {
            return null;
        }
        List<String> valueList = headList.get(key);
        if (CollectionUtil.isEmpty(valueList)) {
            return null;
        }
        return valueList.get(0);
    }
}