/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.response.merchant;

import com.fshows.lakala.request.merchant.LakalaFeeRateRequest;
import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

import java.util.Set;

/**
 * @author zhubo
 * @version LakalaQueryMerchantResponse.java, v 0.1 2023-02-16 18:29 zhubo
 */
@Data
public class LakalaQueryMerchantResponse extends LakalaBizResponse {

    private static final long serialVersionUID = -1733946055635711245L;

    /**
     * 机构代码
     */
    private String orgCode;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 商户注册名称
     */
    private String merRegName;

    /**
     * 商户详细地址
     */
    private String merRegAddr;

    /**
     * 商户MCC编号
     */
    private String mccCode;

    /**
     * 营业执照名称
     */
    private String merBlisName;

    /**
     * 营业执照号
     */
    private String merBlis;

    /**
     * 营业执照有效期
     */
    private String merBlisExpDt;

    /**
     * 商户经营内容
     */
    private String merBusiContent;

    /**
     * 商户法人姓名
     */
    private String larName;

    /**
     * 法人身份证号码
     */
    private String larIdcard;

    /**
     * 法人身份证有效期
     */
    private String larIdcardExpDt;

    /**
     * 联系人手机号码
     */
    private String merContactMobile;

    /**
     * 商户联系人姓名
     */
    private String merContactName;

    /**
     * 结算账户开户行号
     */
    private String openningBankCode;

    /**
     * 结算账户开户行名称
     */
    private String openningBankName;

    /**
     * 结算账户清算行号
     */
    private String clearingBankCode;

    /**
     * 结算账户账号
     */
    private String acctNo;

    /**
     * 结算账户名称
     */
    private String acctName;

    /**
     * 结算账户性质
     */
    private String acctTypeCode;

    /**
     * 结算周期
     */
    private String settlePeriod;

    /**
     * 结算账户身份证号
     */
    private String acctIdcard;

    /**
     * 商户状态
     */
    private String merStatus;

    /**
     * 网点数据
     */
    private Set<LakalaShopDataResponse> shopData;

    /**
     * 终端数据
     */
    private Set<LakalaTermDataResponse> termData;

    /**
     * 费率数据
     */
    private Set<LakalaFeeRateRequest> feeData;

    /**
     * 限额数据
     */
    private Set<LakalaLimitDataResponse> limitData;
}
