package com.fshows.lakala.enums.trade;

import org.apache.commons.lang3.StringUtils;

/**
 * 拉卡拉交易API响应码枚举
 *
 * @author liluqing
 * @version LakalaResponseCodeEnum.java, v 0.1 2022-03-02 11:04 liluqing
 */
public enum LakalaTradeResponseCodeEnum {
    SUCCESS("成功", "BBS00000"),
    PAYING("交易状态为支付中", "BBS10000")
    ;

    private String name;
    private String value;

    LakalaTradeResponseCodeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static LakalaTradeResponseCodeEnum getByValue(String value) {
        LakalaTradeResponseCodeEnum[] valueList = LakalaTradeResponseCodeEnum.values();
        for (LakalaTradeResponseCodeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}