package com.fshows.lakala.enums.merchant;

import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.request.common.UploadPictureRequest;
import com.fshows.lakala.request.merchant.LakalaAddMerchantRequest;
import com.fshows.lakala.request.merchant.LakalaAddTermRequest;
import com.fshows.lakala.request.merchant.LakalaChangeMerchantRequest;
import com.fshows.lakala.request.merchant.LakalaChangeSettRequest;
import com.fshows.lakala.request.merchant.LakalaQueryContractRequest;
import com.fshows.lakala.request.merchant.LakalaQueryMerchantRequest;
import com.fshows.lakala.request.merchant.LakalaQuerySubMerchantRequest;
import com.fshows.lakala.request.merchant.LakalaRateChangeFeeRequest;
import com.fshows.lakala.request.merchant.LakalaWechatConfigRequest;
import com.fshows.lakala.request.merchant.LakalaWechatRealNameQueryRequest;
import com.fshows.lakala.response.common.UploadPictureReponse;
import com.fshows.lakala.response.merchant.LakalaAddMerchantResponse;
import com.fshows.lakala.response.merchant.LakalaAddTermResponse;
import com.fshows.lakala.response.merchant.LakalaChangeMerchantResponse;
import com.fshows.lakala.response.merchant.LakalaChangeSettResponse;
import com.fshows.lakala.response.merchant.LakalaQueryContractResponse;
import com.fshows.lakala.response.merchant.LakalaQueryMerchantResponse;
import com.fshows.lakala.response.merchant.LakalaQuerySubMerchantResponse;
import com.fshows.lakala.response.merchant.LakalaRateChangeFeeResponse;
import com.fshows.lakala.response.merchant.LakalaWechatConfigResponse;
import com.fshows.lakala.response.merchant.LakalaWechatRealNameQueryResponse;

/**
 * 拉卡拉商户进件入驻相关API
 *
 * @author liluqing
 * @version LakalaMerchantApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum LakalaMerchantApiDefinitionEnum implements ILakalaApiDefinition {
    ADD_MERCHANT(
            "商户入驻接口",
            "api/v2/mms/openApi/addMer",
            LakalaConstant.MERCHANT_API_VERSION_V1,
            LakalaAddMerchantRequest.class,
            LakalaAddMerchantResponse.class
    ),
    ADD_TERM(
            "增网增终进件",
            "api/v2/mms/openApi/addTerm",
            LakalaConstant.MERCHANT_API_VERSION_V1,
            LakalaAddTermRequest.class,
            LakalaAddTermResponse.class
    ),
    CHANGE_MERCHANT(
            "商户信息变更",
            "api/v2/mms/openApi/changeMer",
            LakalaConstant.MERCHANT_API_VERSION_V1,
            LakalaChangeMerchantRequest.class,
            LakalaChangeMerchantResponse.class
    ),
    QUERY_MERCHANT_INCOME(
            "商户进件查询",
            "api/v2/mms/openApi/queryContract",
            LakalaConstant.MERCHANT_API_VERSION_V1,
            LakalaQueryContractRequest.class,
            LakalaQueryContractResponse.class
    ),
    WX_CONFIG(
            "微信参数配置",
            "api/v2/mms/openApi/wechatParamConf",
            null,
            LakalaWechatConfigRequest.class,
            LakalaWechatConfigResponse.class
    ),
    CHANGE_BANK_CARD(
            "商户换绑卡",
            "api/v2/mms/openApi/changeSett",
            LakalaConstant.MERCHANT_API_VERSION_V1,
            LakalaChangeSettRequest.class,
            LakalaChangeSettResponse.class
    ),
    CHANGE_RATE(
            "费率信息变更",
            "api/v2/mms/openApi/changeFee",
            LakalaConstant.MERCHANT_API_VERSION_V1,
            LakalaRateChangeFeeRequest.class,
            LakalaRateChangeFeeResponse.class
    ),
    QUERY_MERCHANT_INFO(
            "商户信息查询",
            "api/v2/mms/openApi/queryMerchant",
            LakalaConstant.MERCHANT_API_VERSION_V1,
            LakalaQueryMerchantRequest.class,
            LakalaQueryMerchantResponse.class
    ),
    QUERY_SUB_MERHCNAT_INFO(
            "商户报备信息查询",
            "api/v2/mms/openApi/querySubMerInfo",
            LakalaConstant.MERCHANT_API_VERSION_V1,
            LakalaQuerySubMerchantRequest.class,
            LakalaQuerySubMerchantResponse.class
    ),
    UPLOAD_FILE(
            "文件上传",
            "api/v2/mms/openApi/uploadFile",
            LakalaConstant.MERCHANT_API_VERSION_V1,
            UploadPictureRequest.class,
            UploadPictureReponse.class
    ),
    WECHAT_REAL_NAME_QUERY(
            "微信实名认证结果查询",
            "mms/openApi/wechatRealNameQuery",
            LakalaConstant.MERCHANT_API_VERSION_V1,
            LakalaWechatRealNameQueryRequest.class,
            LakalaWechatRealNameQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求Class类型
     */
    private Class requestClass;
    /**
     * 响应Class类型
     */
    private Class responseClass;


    LakalaMerchantApiDefinitionEnum(String name,
                                    String apiSubURI,
                                    String version,
                                    Class requestClass,
                                    Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}