/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.lakala.response.settle;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 账管家余额查询
 *
 * @author liluqing
 * @version LakalaEwalletBalanceQueryResponse.java, v 0.1 2023-02-28 14:44
 */
@Data
public class LakalaEwalletBalanceQueryResponse extends LakalaBizResponse {

    private static final long serialVersionUID = -3075923326650824594L;

    /**
     * 账号 (必填参数)
     * 示例：
     */
    @NotBlank
    private String payNo;

    /**
     * 账户状态 (必填参数)
     * 示例：<br>CLOSE 销户<br>NORMAL 正常<br>FREEZE 冻结<br>STOPPAY 止付
     */
    @NotBlank
    private String acctSt;

    /**
     * 冻结余额（单位元） (必填参数)
     * 示例：
     */
    @NotBlank
    private String forceBalance;

    /**
     * 上日余额（单位元） (必填参数)
     * 示例：
     */
    @NotBlank
    private String hisBalance;

    /**
     * 实时余额（单位元） (必填参数)
     * 示例：
     */
    @NotBlank
    private String reBalance;

    /**
     * 当前可用余额（单位元）= 实时余额 - 冻结余额 (必填参数)
     * 示例：
     */
    @NotBlank
    private String curBalance;
}