/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaQueryMerchantResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author zhubo
 * @version LakalaQueryMerchantRequest.java, v 0.1 2023-02-16 18:28 zhubo
 */
@Data
public class LakalaQueryMerchantRequest extends LakalaBizRequest<LakalaQueryMerchantResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 963604550617877072L;

    /**
     * 接口版本号1.0 (必填参数)
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构代码 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "机构代码长度不能超过32")
    private String orgCode;

    /**
     * 拉卡拉内部商户号
     */
    @Length(max = 32, message = "拉卡拉内部商户号长度不能超过32")
    private String merInnerNo;

    /**
     * 银联商户号
     */
    @Length(max = 32, message = "银联商户号长度不能超过32")
    private String merCupNo;
}
