/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lakala.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.LakalaHttpResult;
import com.fshows.lakala.client.base.LakalaUploadFileClient;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseMerchantRequest;
import com.fshows.lakala.request.common.UploadPictureRequest;
import com.fshows.lakala.response.base.LakalaBaseMerchantResponse;
import com.fshows.lakala.response.common.UploadPictureReponse;
import com.fshows.lakala.util.LogUtil;
import com.fshows.lakala.util.ReqIdUtil;
import com.fshows.lakala.util.ValidateUtil;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LakalaUploadFileClientImpl
implements LakalaUploadFileClient {
    private static final Logger log = LoggerFactory.getLogger(LakalaUploadFileClientImpl.class);
    private static final String URL = "api/v2/mms/openApi/uploadFile";
    private static final String SUCCESS = "000000";
    private ApiClientConfig apiClientConfig;
    private IHttpRequest httpRequest;
    private ISigner signer;
    private String orgCode;

    public LakalaUploadFileClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer, String orgCode) {
        this.apiClientConfig = apiClientConfig;
        this.httpRequest = httpRequest;
        this.signer = signer;
        this.orgCode = orgCode;
    }

    @Override
    public UploadPictureReponse uploadPicture(UploadPictureRequest request) throws LakalaApiException {
        if (null == request) {
            LogUtil.error(log, "uploadPicture >> \u53c2\u6570\u4e3a\u7a7a");
            throw new LakalaApiException("\u56fe\u7247\u4e0a\u4f20\u53c2\u6570\u4e3a\u7a7a");
        }
        ValidateUtil.validateWithThrow(request, new Class[0]);
        request.setVersion("2.0");
        request.setOrderNo(ReqIdUtil.getOrderNo());
        request.setOrgCode(this.orgCode);
        LakalaBaseMerchantRequest baseMerchantRequest = this.buildRequest(request);
        String body = this.buildBody(baseMerchantRequest);
        String reqUrl = this.apiClientConfig.getApiParentURL() + URL;
        SignParam signParam = this.buildSignParam(baseMerchantRequest, body);
        String authorization = this.signer.sign(signParam, this.apiClientConfig);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", authorization);
        long beginTime = System.currentTimeMillis();
        try {
            LogUtil.info(log, "\u3010lakala-sdk\u3011\u8bf7\u6c42\u5f00\u59cb >> url={}", reqUrl, headers, beginTime);
            LakalaHttpResult result = this.httpRequest.post(reqUrl, authorization, signParam.getBody(), this.apiClientConfig);
            LogUtil.info(log, "\u3010lakala-sdk\u3011\u8bf7\u6c42\u7ed3\u675f >> url={}, response={}, lakalaTraceId={}, cost={}ms", reqUrl, result.getBody(), result.getLakalaTraceId(), System.currentTimeMillis() - beginTime);
            if (null == result) {
                throw new LakalaApiException("lakala\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSONObject.parseObject((String)result.getBody());
            UploadPictureReponse uploadPictureReponse = (UploadPictureReponse)jsonObject.getObject("respData", UploadPictureReponse.class);
            jsonObject.remove((Object)"respData");
            LakalaBaseMerchantResponse baseMerchantResponse = (LakalaBaseMerchantResponse)jsonObject.toJavaObject(LakalaBaseMerchantResponse.class);
            System.out.println(baseMerchantResponse);
            if (null == baseMerchantResponse || !SUCCESS.equals(baseMerchantResponse.getRetCode())) {
                throw new LakalaApiException("\u62c9\u5361\u62c9\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
            }
            return uploadPictureReponse;
        }
        catch (IOException e) {
            LogUtil.error(log, "\u3010lakala-sdk\u3011\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38 >> url={}, cost={}ms", e, reqUrl, System.currentTimeMillis() - beginTime);
            throw new LakalaApiException("\u8bf7\u6c42lakala\u63a5\u53e3\u5f02\u5e38", e);
        }
    }

    private LakalaBaseMerchantRequest buildRequest(UploadPictureRequest request) {
        LakalaBaseMerchantRequest<UploadPictureRequest> baseMerchantRequest = new LakalaBaseMerchantRequest<UploadPictureRequest>();
        baseMerchantRequest.setTimestamp(System.currentTimeMillis());
        baseMerchantRequest.setRnd(RandomUtil.randomString((int)12));
        baseMerchantRequest.setVer("2.0");
        baseMerchantRequest.setReqId(ReqIdUtil.getId());
        baseMerchantRequest.setReqData(request);
        return baseMerchantRequest;
    }

    protected String buildBody(LakalaBaseMerchantRequest request) {
        return JSONObject.toJSONString((Object)request);
    }

    private SignParam buildSignParam(LakalaBaseMerchantRequest lakalaBaseRequest, String bodyStr) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setSerialNo(this.apiClientConfig.getSerialNo());
        signParam.setBody(bodyStr);
        signParam.setNonceStr(lakalaBaseRequest.getRnd());
        signParam.setTimeStamp(lakalaBaseRequest.getTimestamp() / 1000L);
        return signParam;
    }
}

