package com.fshows.lakala.util;

import cn.hutool.core.util.RandomUtil;

import java.util.Random;
import java.util.UUID;

/**
 * @author eden
 * @date 2018/5/21 下午3:36
 * @desc
 */
public class RandomStringGenerator {

    /**
     * 数字0-9
     **/
    private static final char[] NUMBERS = "0123456789".toCharArray();
    /**
     * 数字字母
     **/
    private static final char[] NUMBERS_LETTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    /**
     * 生成指定长度的随机数字
     *
     * @param len
     * @return
     */
    public static String genRandomNum(final int len) {
        return genRandomString(NUMBERS, len);
    }

    /**
     * 生成指定长度的随机字母数字组合
     *
     * @param len
     * @return
     */
    public static String genRandomAlphanumeric(final int len) {

        return genRandomString(NUMBERS_LETTERS, len);
    }

    /**
     * 生成指定长度的随机字符串
     *
     * @param len
     * @return
     */
    public static String genRandomString(final char[] source, final int len) {
        StringBuilder result = new StringBuilder(len);
        // 生成的密码的长度
        int count = 0;
        Random rand = new Random();
        while (count < len) {
            int i = rand.nextInt(source.length);
            result.append(source[i]);
            count++;
        }
        return result.toString();
    }

    public static String genUUIDString() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}
