/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaChangeFeeResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Set;

/**
 * @author zhubo
 * @version LakalaChangeFeeRequest.java, v 0.1 2023-02-16 16:56 zhubo
 */
@Data
public class LakalaChangeFeeRequest extends LakalaBizRequest<LakalaChangeFeeResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 7746856108713800238L;

    /**
     * 接口版本号1.0(必填参数)
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号1.0长度不能超过8")
    private String version;

    /**
     * 订单编号(必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构代码(必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "机构代码长度不能超过32")
    private String orgCode;

    /**
     * 商户内部商户号(必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "商户内部商户号长度不能超过32")
    private String merInnerNo;

    /**
     * 银联商户号(必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "银联商户号长度不能超过32")
    private String merCupNo;

    /**
     * 银联终端号
     */
    @Length(max = 32, message = "银联终端号长度不能超过32")
    private String termNo;

    /**
     * 回调地址(必填参数)
     */
    @NotBlank
    @Length(max = 64, message = "回调地址长度不能超过64")
    private String retUrl;

    /**
     * 附件信息集合
     */
    private Set<LakalaFileDataRequest> fileData;

    /**
     * 费率信息集合(必填参数)
     */
    @NotBlank
    private Set<LakalaFeeRateRequest> feeData;
}
