/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseSettleRequest;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.base.LakalaBaseSettleResponse;
import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.util.ReqIdUtil;

/**
 * 拉卡拉结算接口客户端
 *
 * @author liluqing
 * @version TradeLakalaApiClientImpl.java, v 0.1 2022-03-04 15:02
 */
public class SettleLakalaApiClientImpl extends AbstractLakalaApiClientImpl<LakalaBaseSettleRequest, LakalaBaseSettleResponse> {

    private static SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    static {
        SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }

    public SettleLakalaApiClientImpl(ApiClientConfig apiClientConfig) throws LakalaApiException {
        super(apiClientConfig);
    }

    public SettleLakalaApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws LakalaApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends LakalaBizResponse, R extends ILakalaApiDefinition> LakalaBaseSettleResponse<T> execute(LakalaBizRequest<T, R> request, R settleApiDefinitionEnum) throws LakalaApiException {
        return super.doExecute(request, settleApiDefinitionEnum);
    }

    /**
     * 添加公共参数构建完整的请求
     *
     * @param bizRequest              业务请求参数
     * @param settleApiDefinitionEnum
     * @return
     */
    @Override
    protected LakalaBaseSettleRequest buildLakalaBizRequest(LakalaBizRequest bizRequest, ILakalaApiDefinition settleApiDefinitionEnum) {
        LakalaBaseSettleRequest request = new LakalaBaseSettleRequest();
        request.setTimestamp(System.currentTimeMillis());
        request.setRnd(RandomUtil.randomString(12));
        request.setVer(settleApiDefinitionEnum.getVersion());
        request.setReqId(ReqIdUtil.getId());
        request.setReqData(bizRequest);
        return request;
    }

    @Override
    protected SignParam buildSignParam(LakalaBaseSettleRequest lakalaBaseRequest, String bodyStr) {
        SignParam signParam = new SignParam();
        signParam.setAppid(apiClientConfig.getAppId());
        signParam.setSerialNo(apiClientConfig.getSerialNo());
        signParam.setBody(bodyStr);
        signParam.setNonceStr(lakalaBaseRequest.getRnd());
        signParam.setTimeStamp(lakalaBaseRequest.getTimestamp() / 1000L);
        return signParam;
    }

    @Override
    protected String serializableRequest(LakalaBaseSettleRequest lakalaBaseRequest, ILakalaApiDefinition settleApiDefinitionEnum) {
        return JSONObject.toJSONString(lakalaBaseRequest);
    }

    @Override
    protected LakalaBaseSettleResponse parseResponse(String resBody, ILakalaApiDefinition settleApiDefinitionEnum) {
        JSONObject resJson = JSONObject.parseObject(resBody);

        // 业务响应结果
        LakalaBizResponse bizResData = (LakalaBizResponse) resJson.getObject(LakalaConstant.LAKALA_RESPONSE_BIZ_KEY, settleApiDefinitionEnum.getResponseClass());
        resJson.remove(LakalaConstant.LAKALA_RESPONSE_BIZ_KEY);

        // 完整响应结果
        LakalaBaseSettleResponse response = resJson.toJavaObject(LakalaBaseSettleResponse.class);
        response.setRespData(bizResData);
        return response;
    }
}