/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.client.base;

import com.fshows.lakala.constant.CommonConstant;
import com.fshows.lakala.enums.base.SignTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 客户端配置信息model
 *
 * @author liluqing
 * @version ClientMetaInfoModel.java, v 0.1 2022-03-01 20:37
 */
@Data
public class ApiClientConfig {

    /**
     * 拉卡拉接口网关根URL
     */
    @NotBlank(message = "拉卡拉api客户端网关根地址不能为空")
    protected String apiParentURL;

    /**
     * appid
     */
    @NotBlank(message = "拉卡拉api客户端appId不能为空")
    protected String appId;

    /**
     * 证书序列号
     */
    @NotBlank(message = "拉卡拉api客户端serialNo不能为空")
    protected String serialNo;

    /**
     * 用于加签的付呗私钥
     */
    @NotBlank(message = "拉卡拉api客户端付呗私钥不能为空")
    protected String fubeiPrivateKey;

    /**
     * 用于验签的拉卡拉公钥
     */
    @NotBlank(message = "拉卡拉api客户端拉卡拉公钥不能为空")
    protected String lakalaPublicKey;

    /**
     * 加签算法类型
     */
    protected SignTypeEnum signTypeEnum = SignTypeEnum.RSA2;

    /**
     * 是否对拉卡拉响应结果进行验签
     */
    protected boolean vrifySignResponse = true;

    /**
     * 是否对参数进行前置校验
     */
    protected boolean checkParam = true;

    /**
     * http连接超时时间
     */
    protected int connectionTimeout = CommonConstant.DEFAULT_CONNECTION_TIMEOUT;

    /**
     * http response读取超时时间
     */
    protected int readTimeout = CommonConstant.DEFAULT_READ_TIMEOUT;

    /**
     * 默认编码格式，默认为utf-8
     */
    protected String charset = CommonConstant.UTF_8;

}