/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaAddTermResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 商户进价
 *
 * @author liluqing
 * @version LakalaAddMerchantRequest.java, v 0.1 2022-03-08 15:48
 */
@Data
public class LakalaAddTermRequest extends LakalaBizRequest<LakalaAddTermResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 8441206421249264084L;

    /**
     * 接口版本号 (必填参数)
     * 1.0
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号（便于后续跟踪排查问题及核对报文） (必填参数)
     * 14位年月日时（24小时制）分秒+8位的随机数（不重复）如：2021020112000012345678
     */
    @NotBlank
    @Length(max = 32, message = "订单编号（便于后续跟踪排查问题及核对报文）长度不能超过32")
    private String orderNo;

    /**
     * 进件POS类型 —按接入系统做控制，参见【POS类型字典表】 (必填参数)
     * GENERAL_POS
     */
    @NotBlank
    @Length(max = 32, message = "进件POS类型 —按接入系统做控制，参见【POS类型字典表】长度不能超过32")
    private String posType;

    /**
     * 机构代码 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "机构代码长度不能超过32")
    private String orgCode;

    /**
     * 商户内部商户号(拉卡拉内部商户号和银联商户号必须传一个，都送以内部商户号为准) (必填参数)
     * 4002019111800000020
     */
    @NotBlank
    @Length(max = 32, message = "商户内部商户号(拉卡拉内部商户号和银联商户号必须传一个，都送以内部商户号为准)长度不能超过32")
    private String merInnerNo;

    /**
     * 银联商户号 (必填参数)
     * 82229005411000A
     */
    @NotBlank
    @Length(max = 32, message = "银联商户号长度不能超过32")
    private String merCupNo;

    /**
     * 新增网点 (选填)
     */
    private Object shopData;

    /**
     * 网点名称 (选填)
     */
    @Length(max = 64, message = "网点名称长度不能超过64")
    private String shopName;

    /**
     * 网点地址区划代码 (选填)
     */
    @Length(max = 16, message = "网点地址区划代码长度不能超过16")
    private String shopDistCode;

    /**
     * 网点详细地址 (选填)
     */
    @Length(max = 128, message = "网点详细地址长度不能超过128")
    private String shopAddr;

    /**
     * 网点联系人手机号 (选填)
     */
    @Length(max = 32, message = "网点联系人手机号长度不能超过32")
    private String shopContactMobile;

    /**
     * 网点门店联系人名称 (选填)
     */
    @Length(max = 18, message = "网点门店联系人名称长度不能超过18")
    private String shopContactName;

    /**
     * 终端详情 (必填参数)
     */
    @NotNull
    private Object termData;

    /**
     * 网点ID (选填)
     */
    @Length(max = 32, message = "网点ID长度不能超过32")
    private String shopId;

    /**
     * 终端数量（1-5） 最大5个终端 (必填参数)
     * 1
     */
    @NotBlank
    @Length(max = 8, message = "终端数量（1-5） 最大5个终端长度不能超过8")
    private String termNum;

    /**
     * 终端号 (选填)
     */
    @Length(max = 32, message = "终端号长度不能超过32")
    private String termNo;

    /**
     * 终端设备序列号 (选填)
     */
    @Length(max = 64, message = "终端设备序列号长度不能超过64")
    private String devSerialNo;

    /**
     * 设备型号 (选填)
     */
    @Length(max = 32, message = "设备型号长度不能超过32")
    private String devTypeName;

    /**
     * 终端版本号 (选填)
     */
    @Length(max = 32, message = "终端版本号长度不能超过32")
    private String termVer;

    /**
     * 回调地址 (必填参数)
     * http://
     */
    @NotBlank
    @Length(max = 64, message = "回调地址长度不能超过64")
    private String retUrl;

    /**
     * 费率信息集合 (必填参数)
     * 参看下方【费率信息】
     */
    @NotNull
    private List<LakalaFeeRateRequest> feeData;

    /**
     * 附件信息集合 (选填)
     */
    private List<LakalaFileDataRequest> fileData;

}