/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.kqbill.handler;

import cn.hutool.core.util.StrUtil;
import com.fshows.kqbill.handler.HttpClientCert;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class HttpsClientFactory {
    public CloseableHttpClient createSSLClient(HttpClientCert httpClientCert) throws Exception {
        SSLContextBuilder builder = SSLContexts.custom();
        if (httpClientCert.getKeyStore() != null) {
            builder = StrUtil.isEmpty((CharSequence)httpClientCert.getKeyStorePwd()) ? builder.loadKeyMaterial(httpClientCert.getKeyStore(), null) : builder.loadKeyMaterial(httpClientCert.getKeyStore(), httpClientCert.getKeyStorePwd().toCharArray());
        }
        SSLContext sslContext = httpClientCert.getTrustStore() != null ? builder.loadTrustMaterial(httpClientCert.getTrustStore(), (TrustStrategy)new TrustSelfSignedStrategy()).build() : builder.loadTrustMaterial(null, (xcs, string) -> true).build();
        SSLConnectionSocketFactory sslSocketFactory = this.getConnectionSocketFactory(sslContext, httpClientCert.getSSLVersion());
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(Integer.valueOf(httpClientCert.getSoTimeout()).intValue()).setConnectTimeout(Integer.valueOf(httpClientCert.getConnTimeout()).intValue()).build();
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
    }

    private SSLConnectionSocketFactory getConnectionSocketFactory(SSLContext sslContext, String SSLVersion) {
        if (StrUtil.isEmpty((CharSequence)SSLVersion)) {
            return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        return new SSLConnectionSocketFactory(sslContext, new String[]{SSLVersion}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }
}

