package com.fshows.kqbill.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 富友接口类型
 * （富友富管家有一部分接口是加密的，另一部分则不需要加密。加密接口需要对入参做加密和加签，普通接口则只需要加签，不需要做参数加密）
 *
 * @author liluqing
 * @version FuiouApiTypeEnum.java, v 0.1 2023-12-25 14:24 liluqing
 */
public enum FuStewardApiTypeEnum {
    ENCRYPT_API("加密接口", "ENCRYPT_API"),
    NORMAL_API("普通接口", "ENCRYPT_API");

    private String name;
    private String value;

    FuStewardApiTypeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static FuStewardApiTypeEnum getByValue(String value) {
        FuStewardApiTypeEnum[] valueList = FuStewardApiTypeEnum.values();
        for (FuStewardApiTypeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}