/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.kqbill.handler;

import com.fshows.kqbill.handler.HttpClientCert;
import com.fshows.kqbill.handler.HttpsClientFactory;
import com.fshows.kqbill.handler.KqbillClientConfigModel;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class KqbillPostHttpWithSSLRequestHandler
implements IHttpRequestHandler {
    private static final int SO_TIMEOUT = 60000;
    private static final int CONN_TIMEOUT = 10000;
    private CloseableHttpClient httpClient;

    public KqbillPostHttpWithSSLRequestHandler(DefaultClientConfigModel configModel) {
        if (configModel.getApiParentURL().startsWith("https")) {
            try {
                this.httpClient = this.createHttpsClient(configModel);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.httpClient = HttpClientBuilder.create().setMaxConnPerRoute(500).setMaxConnTotal(500).build();
        }
    }

    public ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        HttpPost httpPost = new HttpPost(apiRequestModel.getApiURL());
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(10000).build();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity((HttpEntity)new StringEntity(apiRequestModel.getRequestBody(), Consts.UTF_8));
        String resp = (String)this.httpClient.execute((HttpUriRequest)httpPost, httpresponse -> {
            HttpEntity entity = httpresponse.getEntity();
            if (entity != null) {
                return EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            }
            return null;
        });
        ApiResponseModel responseModel = new ApiResponseModel();
        responseModel.setResponseBody(resp);
        return responseModel;
    }

    private CloseableHttpClient createHttpsClient(DefaultClientConfigModel model) throws Exception {
        KqbillClientConfigModel configModel = (KqbillClientConfigModel)model;
        HttpClientCert httpClientCert = new HttpClientCert();
        httpClientCert.setKeyStore(configModel.getKeyStore());
        httpClientCert.setKeyStorePwd(configModel.getSSLKeyPass());
        httpClientCert.setConnTimeout(10000);
        httpClientCert.setSoTimeout(60000);
        httpClientCert.setSSLVersion(configModel.getSSLVersion());
        HttpsClientFactory factory = new HttpsClientFactory();
        return factory.createSSLClient(httpClientCert);
    }
}

