/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;

/**
 * 微信公众号/小程序支付 response
 *
 * @author
 * @version JlOpenTransOfficialPayResponse.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenTransOfficialPayResponse extends JlBizResponse {
    private static final long serialVersionUID = -3102377535667720647L;

    /**
     * 状态，1：待确认，3：失败
     */
    private String status;

    /**
     * 终端号，由嘉联生成，8位数字
     */
    private String termNo;

    /**
     * 终端设备号，商户收银设备终端信息
     */
    private String deviceInfo;

    /**
     * 平台订单号，返回的嘉联订单号
     */
    private String transactionId;

    /**
     * 外部订单号，商家系统内部订单号
     */
    private String outTradeNo;

    /**
     * 交易金额，单位为分，只能为整数
     */
    private String totalFee;

    /**
     * 支付信息，微信生成的预支付标识，用于后续接口调用中使用
     */
    private String payInfo;

    /**
     * 订单时间，下单请求时间，形如yyyy-MM-dd HH:mm:ss
     */
    private String orderTime;

    /**
     * 交易类型，例如：wxpay
     */
    private String payType;

    /**
     * 交易时间，用户付款时间，形如yyyy-MM-dd HH:mm:ss
     */
    private String transTime;
}