/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;

/**
 * 微信公众号/小程序支付 response
 *
 * @author
 * @version JlOpenTransOfficialPayResponse.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenTransChnqueryResponse extends JlBizResponse {
    private static final long serialVersionUID = -5755514179238645189L;

    /**
     * 交易状态，1：待确认，2：成功，3：失败，4：已撤销，5：已退款，6：关单中
     */
    private String status;

    /**
     * 平台订单号，嘉联系统生成的订单号
     */
    private String transactionId;

    /**
     * 外部订单号，商家系统生成的订单号
     */
    private String outTradeNo;

    /**
     * 渠道订单号，支付宝、微信、银联等支付渠道的订单号
     */
    private String chnTransactionId;

    /**
     * 交易金额，单位为分，只能为整数
     */
    private String totalFee;

    /**
     * 订单时间，下单请求的时间，格式为yyyy-MM-dd HH:mm:ss
     */
    private String orderTime;

    /**
     * 交易时间，嘉联系统的交易时间，格式为yyyy-MM-dd HH:mm:ss
     */
    private String transTime;

    /**
     * 付款时间，用户实际付款的时间，格式为yyyy-MM-dd HH:mm:ss
     */
    private String payTime;

    /**
     * 终端号，由嘉联生成，长度为8位数字
     */
    private String termNo;

    /**
     * 终端设备号，商户收银设备终端的识别码
     */
    private String deviceInfo;

    /**
     * 备注信息，交易的备注，透传给接入方
     */
    private String remark;

    /**
     * 操作员编号，商家收银员的编号
     */
    private String opUserId;

    /**
     * 门店号，商家的分店编号
     */
    private String opShopId;

    /**
     * 实际付款金额，使用优惠券后的实际付款金额
     */
    private String finnalAmount;

    /**
     * 优惠总金额，渠道返回的优惠活动金额或代金券金额
     */
    private String discountAmount;

    /**
     * 优惠活动名称，本次交易产生的优惠活动的名称
     */
    private String discountName;

    /**
     * 优惠代金券详情，优惠券的详细信息
     */
    private String couponInfo;

    /**
     * 交易类型，支付方式，如微信支付（wxpay）、支付宝（alipay）、银联（unionpay）
     */
    private String payType;

    /**
     * 用户的openid，对应公众号下的用户唯一标识
     */
    private String subOpenid;

    /**
     * 扫码标识，在“jlpay”支付模式下，付款方扫码后该字段返回1
     */
    private String qrcodeState;
}