/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author mengqf
 * @version JlWechatPayAuthBindRequest.java, v 0.1 2025-01-15 10:27 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper = true)
public class JlWechatPayAuthBindRequest extends JlBizRequest {
    private static final long serialVersionUID = 7901381892433247309L;

    /**
     * 交易类型 wxpay
     */
    @NotBlank(message = "交易类型不能为空")
    @Length(max = 10, message = "交易类型长度不能超过10")
    private String payType;

    /**
     * JSAPI支付授权目录
     */
    @Length(max = 128, message = "JSAPI支付授权目录长度不能超过128")
    private String jsapiPath;

    /**
     * 公众号ID
     */
    private String subAppid;

    /**
     * 终端IP
     */
    private String mchCreateIp;
}