/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 支付宝服务窗/小程序支付 request
 *
 * @author
 * @version JlOpenTransWaph5payRequest.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenTransWaph5payRequest extends JlBizRequest {

    private static final long serialVersionUID = -4127072132751694821L;

    /**
     * 终端号，由嘉联生成，8位数字
     * (必填)
     */
    @NotBlank(message = "终端号不能为空")
    @Length(max = 8, message = "终端号长度不能超过8")
    private String termNo;

    /**
     * 交易类型 alipay
     * (必填)
     */
    @NotBlank(message = "交易类型不能为空")
    @Length(max = 10, message = "交易类型长度不能超过10")
    private String payType;

    /**
     * 买家支付宝账号
     * (选填)
     */
    @Length(max = 32, message = "买家支付宝账号长度不能超过32")
    private String buyerLogonId;

    /**
     * 买家支付宝用户ID
     * (必填)
     */
    @NotBlank(message = "买家支付宝用户ID不能为空")
    @Length(max = 32, message = "买家支付宝用户ID长度不能超过32")
    private String buyerId;

    /**
     * 指定支付方式
     * (选填)
     */
    @Length(max = 60, message = "指定支付方式长度不能超过60")
    private String limitPay;

    /**
     * 外部订单号，商户系统内部订单号
     * (必填)
     */
    @NotBlank(message = "外部订单号不能为空")
    @Length(max = 32, message = "外部订单号长度不能超过32")
    private String outTradeNo;

    /**
     * 订单有效期
     * (选填)
     */
    @Length(max = 4, message = "订单有效期长度不能超过4")
    private String paymentValidTime;

    /**
     * 商品标题
     * (必填)
     */
    @NotBlank(message = "商品标题不能为空")
    @Length(max = 32, message = "商品标题长度不能超过32")
    private String body;

    /**
     * 商品描述
     * (必填)
     */
    @NotBlank(message = "商品描述不能为空")
    @Length(max = 500, message = "商品描述长度不能超过500")
    private String attach;

    /**
     * 交易金额，单位为分
     * (必填)
     */
    @NotBlank(message = "交易金额不能为空")
    private String totalFee;

    /**
     * 分期标识，是否分期付款
     * (选填)
     */
    @Length(max = 1, message = "分期标识长度不能超过1")
    private String isHirePurchase;

    /**
     * 分期数，花呗分期数
     * (选填)
     */
    @Length(max = 2, message = "分期数长度不能超过2")
    private String hirePurchaseNum;

    /**
     * 卖家承担的手续费比例
     * (选填)
     */
    @Length(max = 3, message = "手续费比例长度不能超过3")
    private String hirePurchaseSellerPercent;

    /**
     * 备注信息
     * (选填)
     */
    @Length(max = 500, message = "备注信息长度不能超过500")
    private String remark;

    /**
     * 回调地址，异步接收支付结果通知的回调地址
     * (选填)
     */
    @Length(max = 200, message = "回调地址长度不能超过200")
    private String notifyUrl;

    /**
     * 操作员，商家收银员编号
     * (选填)
     */
    @Length(max = 32, message = "操作员编号长度不能超过32")
    private String opUserId;

    /**
     * 门店号
     * (选填)
     */
    @Length(max = 32, message = "门店号长度不能超过32")
    private String opShopId;

    /**
     * 终端设备号，商户收银设备终端信息
     * (选填)
     */
    @Length(max = 32, message = "终端设备号长度不能超过32")
    private String deviceInfo;

    /**
     * 终端IP，付款方的客户端IP
     * (选填)
     */
    @Length(max = 15, message = "终端IP长度不能超过15")
    private String mchCreateIp;

    /**
     * 经度，地理位置经度
     * (选填)
     */
    @Length(max = 10, message = "经度长度不能超过10")
    private String longitude;

    /**
     * 纬度，地理位置纬度
     * (选填)
     */
    @Length(max = 10, message = "纬度长度不能超过10")
    private String latitude;

    /**
     * 终端信息，商户侧受理终端信息
     * (选填)
     */
    private String terminalInfo;
}