/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 微信公众号/小程序支付 request
 *
 * @author
 * @version JlOpenTransOfficialPayRequest.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenTransOfficialPayRequest extends JlBizRequest {
    private static final long serialVersionUID = 1808735248885989330L;

    /**
     * 终端号，由嘉联生成，8位数字
     * (必填)
     */
    @NotBlank(message = "终端号不能为空")
    @Length(max = 8, message = "终端号长度不能超过8")
    private String termNo;

    /**
     * 交易类型，例如：wxpay（微信公众号、微信小程序）
     * (必填)
     */
    @NotBlank(message = "交易类型不能为空")
    @Length(max = 10, message = "交易类型长度不能超过10")
    private String payType;

    /**
     * 用户标识，在公众号/小程序下的唯一标识
     * (必填)
     */
    @NotBlank(message = "用户标识不能为空")
    @Length(max = 32, message = "用户标识长度不能超过32")
    private String openId;

    /**
     * 微信分配的公众账号ID，注：小程序支付sub_appid则必传
     * (选填)
     */
    @Length(max = 20, message = "公众账号ID长度不能超过20")
    private String subAppid;

    /**
     * 指定支付方式，no_credit：指定不能使用信用卡支付
     * (选填)
     */
    @Length(max = 60, message = "指定支付方式长度不能超过60")
    private String limitPay;

    /**
     * 外部订单号，由商户自定义，不能重复
     * (必填)
     */
    @NotBlank(message = "外部订单号不能为空")
    @Length(max = 32, message = "外部订单号长度不能超过32")
    private String outTradeNo;

    /**
     * 订单有效期，单位：分钟，默认有效时间：20分钟
     * (选填)
     */
    @Length(max = 4, message = "订单有效期长度不能超过4")
    private String paymentValidTime;

    /**
     * 商品标题，展示在支付账单详情页面
     * (必填)
     */
    @NotBlank(message = "商品标题不能为空")
    @Length(max = 32, message = "商品标题长度不能超过32")
    private String body;

    /**
     * 商品描述，商品的详细描述
     * (必填)
     */
    @NotBlank(message = "商品描述不能为空")
    @Length(max = 500, message = "商品描述长度不能超过500")
    private String attach;

    /**
     * 交易金额，单位为分，只能为整数
     * (必填)
     */
    @NotBlank(message = "交易金额不能为空")
    @Length(max = 15, message = "交易金额长度不能超过15")
    private String totalFee;

    /**
     * 备注信息，交易结果透传推送
     * (选填)
     */
    @Length(max = 500, message = "备注信息长度不能超过500")
    private String remark;

    /**
     * 回调地址，异步接收支付结果通知的回调地址
     * (选填)
     */
    @Length(max = 200, message = "回调地址长度不能超过200")
    private String notifyUrl;

    /**
     * 操作员编号，商家收银员编号
     * (选填)
     */
    @Length(max = 32, message = "操作员编号长度不能超过32")
    private String opUserId;

    /**
     * 门店号
     * (选填)
     */
    @Length(max = 32, message = "门店号长度不能超过32")
    private String opShopId;

    /**
     * 终端设备号，商户收银设备终端信息
     * (选填)
     */
    @Length(max = 32, message = "终端设备号长度不能超过32")
    private String deviceInfo;

    /**
     * 终端IP，付款方客户端IP
     * (选填)
     */
    @Length(max = 15, message = "终端IP长度不能超过15")
    private String mchCreateIp;

    /**
     * 经度，设备经纬度，百度坐标系
     * (选填)
     */
    @Length(max = 10, message = "经度长度不能超过10")
    private String longitude;

    /**
     * 纬度，设备经纬度，百度坐标系
     * (选填)
     */
    @Length(max = 10, message = "纬度长度不能超过10")
    private String latitude;

    /**
     * 订单优惠标记. 只对微信单品有效，用于区分订单是否可以享受优惠，字段值必须是在微信后台配置券时设置的值，否则不享受单品优惠
     * (选填)
     */
    @Length(max = 32, message = "订单优惠标记长度不能超过32")
    private String goodsTag;

    /**
     * 单品优惠活动该字段必传，且必须按照规范上传，JSON格式
     * (选填)
     */
    @Length(max = 6000, message = "商品详情长度不能超过6000")
    private String goodsData;

    /**
     * 终端信息，商户侧受理终端信息
     * (选填)
     */
    private String terminalInfo;
}