/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

/**
 * 订单查询 request
 *
 * @author
 * @version JlOpenTransChnqueryPayRequest.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenTransChnqueryPayRequest extends JlBizRequest {
    private static final long serialVersionUID = 1554839458243819252L;
    
    /**
     * 外部订单号，商家系统内部订单号
     * (选填)
     * 示例值：ld2019102216465524
     * (商家系统内部订单号、嘉联平台订单号必须二选一)
     */
    @Length(max = 32, message = "外部订单号长度不能超过32")
    private String outTradeNo;

    /**
     * 平台订单号，嘉联订单号
     * (选填)
     * 示例值：8001155720190917185301156894
     * (商家系统内部订单号、嘉联平台订单号必须二选一)
     */
    @Length(max = 32, message = "平台订单号长度不能超过32")
    private String transactionId;
}