/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 终端加机 request
 *
 * @author
 * @version JlOpenMerchAccessDeviceAddRequest.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenMerchAccessDeviceAddRequest extends JlBizRequest {

    private static final long serialVersionUID = 9015699439488014162L;
    /**
     * 商户号，最大长度为15
     * （必填）
     */
    @Length(max = 15, message = "merchNo长度不能超过15")
    @NotBlank(message = "商户号不能为空")
    private String merchNo;

    /**
     * 加机类型，最大长度为12
     * （必填）
     *
     * term：终端加机，适用于有实体终端的场景，后台会校验库存。此终端支持银行卡、码付交易
     * qrcode：码付加机，适用于生成码付/收银托管API接口term_no，虚拟终端，不校验库存。此终端仅支持码付交易
     * shopCounter：收银台，适用于收银台插件加机，系统会从对应库存随机获取收银台机身号。此终端仅支持码付交易
     */
    @Length(max = 12, message = "deviceType长度不能超过12")
    @NotBlank(message = "加机类型不能为空")
    private String deviceType;

    /**
     * 收银台类型，最大长度为12，只有加机类型为shopCounter时必填项
     * （选填）
     *
     * JLXJL：小精灵收银台
     */
    @Length(max = 12, message = "shopCounterType长度不能超过12")
    private String shopCounterType;

    /**
     * 设备硬件序列号（SN），最大长度为15，只有加机类型为term时必填项
     * （选填）
     */
    @Length(max = 15, message = "deviceNo长度不能超过15")
    private String deviceNo;

    /**
     * 门店编号，最大长度为15
     * （选填）
     */
    @Length(max = 15, message = "shopId长度不能超过15")
    private String shopId;

    /**
     * POS设备打印的交易小票上的商户名称，最大长度为256
     * （选填）
     */
    @Length(max = 256, message = "printMerchName长度不能超过256")
    private String printMerchName;

    /**
     * 交易设备使用详细地址，最大长度为256
     * （选填）
     */
    @Length(max = 256, message = "detAddress长度不能超过256")
    private String detAddress;
}