package com.fshows.apienum;

import com.fshows.request.JlOpenMerchAccessDeviceAddRequest;
import com.fshows.request.JlOpenTransCancelRequest;
import com.fshows.request.JlOpenTransChnqueryPayRequest;
import com.fshows.request.JlOpenTransOfficialPayRequest;
import com.fshows.request.JlOpenTransRefundRequest;
import com.fshows.request.JlOpenTransWaph5payRequest;
import com.fshows.request.JlWechatPayAuthBindRequest;
import com.fshows.response.JlOpenMerchAccessDeviceAddResponse;
import com.fshows.response.JlOpenTransCancelResponse;
import com.fshows.response.JlOpenTransChnqueryResponse;
import com.fshows.response.JlOpenTransOfficialPayResponse;
import com.fshows.response.JlOpenTransRefundResponse;
import com.fshows.response.JlOpenTransWaph5payResponse;
import com.fshows.response.JlWechatPayAuthBindResponse;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;


/**
 * 嘉联相关API
 *
 * @author
 * @version JlpayApiDefinitionEnum.java, v 0.1 2025-01-08 17:28
 */
public enum JlpayApiDefinitionEnum implements IApiDefinition {

    OPEN_TRANS_OFFICIALPAY(
            "微信公众号/小程序支付",
            "/open/trans/officialpay",
            "1.0.0",
            "TRADE",
            JlOpenTransOfficialPayRequest.class,
            JlOpenTransOfficialPayResponse.class
    ),
    OPEN_TRANS_WAPH5PAY(
            "支付宝服务窗/小程序支付",
            "/open/trans/waph5pay",
            "1.0.0",
            "TRADE",
            JlOpenTransWaph5payRequest.class,
            JlOpenTransWaph5payResponse.class
    ),
    OPEN_TRANS_CHNQUERY(
            "订单查询",
            "/open/trans/chnquery",
            "1.0.0",
            "TRADE",
            JlOpenTransChnqueryPayRequest.class,
            JlOpenTransChnqueryResponse.class
    ),
    OPEN_TRANS_REFUND(
            "订单退款",
            "/open/trans/refund",
            "1.0.0",
            "TRADE",
            JlOpenTransRefundRequest.class,
            JlOpenTransRefundResponse.class
    ),
    OPEN_TRANS_CANCEL(
            "订单关闭",
            "/open/trans/cancel",
            "1.0.0",
            "TRADE",
            JlOpenTransCancelRequest.class,
            JlOpenTransCancelResponse.class
    ),
    OPEN_MERCH_ACCESS_DEVICE_ADD(
            "终端加机",
            "/open/merch/access/device/add",
            "1.0.0",
            "MERCHANT",
            JlOpenMerchAccessDeviceAddRequest.class,
            JlOpenMerchAccessDeviceAddResponse.class
    ),
    WECHAT_PAY_AUTH_BIND(
            "绑定支付目录",
            "/open/trans/authbind",
            "1.0.0",
            "MERCHANT",
            JlWechatPayAuthBindRequest.class,
            JlWechatPayAuthBindResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;

    /**
     * 接口版本
     */
    private String version;

    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    /**
     * 接口类型：
     * MERCHANT - 商户接口
     * TRADE  -  交易接口
     * COMMON  - 通用接口
     */
    private String interfaceType;


    JlpayApiDefinitionEnum(String name,
                           String apiSubURI,
                           String version,
                           String interfaceType,
                           Class requestClass,
                           Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}