/*
 * Decompiled with CFR 0.152.
 */
package com.fshows;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.apienum.JlpayApiDefinitionEnum;
import com.fshows.request.JlBizRequest;
import com.fshows.response.JlBizResponse;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.sdk.core.util.ReqIdUtil;
import com.jlpay.open.jlpay.sdk.java.exception.HttpExecutionException;
import com.jlpay.open.jlpay.sdk.java.exception.HttpStatusCodeException;
import com.jlpay.open.jlpay.sdk.java.http.HttpMethod;
import com.jlpay.open.jlpay.sdk.java.http.HttpRequest;
import com.jlpay.open.jlpay.sdk.java.http.HttpResponse;
import com.jlpay.open.jlpay.sdk.java.sign.SignVerifier;
import com.jlpay.open.jlpay.sdk.java.sign.SignVerifierManager;
import com.jlpay.open.jlpay.sdk.java.utils.HttpUtils;
import com.jlpay.open.jlpay.sdk.java.utils.NonceUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JlPayApiClient
extends AbstractApiClient<JlBizRequest, JlBizResponse, JlpayApiDefinitionEnum> {
    private static final Logger log = LoggerFactory.getLogger(JlPayApiClient.class);
    private final SignVerifierManager signVerifierManager;

    public JlPayApiClient(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
        try {
            SignVerifier signVerifier = new SignVerifier(apiClientConfig.getFubeiPrivateKey(), apiClientConfig.getPayCompanyPublicKey());
            this.signVerifierManager = new SignVerifierManager(signVerifier);
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"JlPayApiClient >> \u5609\u8054\u901a\u9053\u516c\u79c1\u94a5\u52a0\u8f7d\u5931\u8d25! ", (Throwable)e);
            throw new FsApiException("\u52a0\u8f7d\u516c\u79c1\u94a5\u5931\u8d25", (Throwable)e);
        }
    }

    public JlBizResponse execute(JlBizRequest request, JlpayApiDefinitionEnum apiDefinition) throws FsApiException {
        return (JlBizResponse)this.doExecute(request, apiDefinition);
    }

    public JlBizResponse execute(JlBizRequest request, JlpayApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }

    protected JlBizResponse doExecute(JlBizRequest request, JlpayApiDefinitionEnum iApiDefinition, DefaultClientConfigModel payConfigModel) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, request});
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, payConfigModel);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            long reqBeginTime = System.currentTimeMillis();
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            long reqEndTime = System.currentTimeMillis();
            Object requestBody = ObjectUtils.defaultIfNull((Object)apiRequestModel.getRequestBody(), (Object)apiRequestModel.getRequestForm());
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f >> url={}, method={}, request={}, response={}, cost={}ms, reqCost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, requestBody, apiResponseModel.getResponseBody(), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime});
            return this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> url={}, method={}, request={}, cost={}ms", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel == null ? "" : apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)(apiRequestModel == null ? "" : apiRequestModel.getRequest())), System.currentTimeMillis() - beginTime});
            throw e;
        }
        catch (Exception e) {
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u672a\u77e5\u5f02\u5e38 >> url={}, method={}, request={}, cost={}ms", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel == null ? "" : apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)(apiRequestModel == null ? "" : apiRequestModel.getRequest())), System.currentTimeMillis() - beginTime});
            throw new FsApiException(e.getMessage(), (Throwable)e);
        }
    }

    protected DefaultRequestContext buildRequestContext(JlpayApiDefinitionEnum tradeApiDefinitionEnum, JlBizRequest request, DefaultClientConfigModel payConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setRequestId(ReqIdUtil.getId());
        context.setIApiDefinition((IApiDefinition)tradeApiDefinitionEnum);
        DefaultClientConfigModel config = (DefaultClientConfigModel)BeanUtil.copyProperties((Object)this.apiClientConfig, DefaultClientConfigModel.class, (String[])new String[0]);
        if (payConfig != null) {
            config.setAgentId(StringUtils.isEmpty((CharSequence)payConfig.getAgentId()) ? this.apiClientConfig.getAgentId() : payConfig.getAgentId());
            config.setAppId(StringUtils.isEmpty((CharSequence)payConfig.getAppId()) ? this.apiClientConfig.getAppId() : payConfig.getAppId());
            config.setFubeiPrivateKey(StringUtils.isEmpty((CharSequence)payConfig.getFubeiPrivateKey()) ? this.apiClientConfig.getFubeiPrivateKey() : payConfig.getFubeiPrivateKey());
            config.setPayCompanyPublicKey(StringUtils.isEmpty((CharSequence)payConfig.getPayCompanyPublicKey()) ? this.apiClientConfig.getPayCompanyPublicKey() : payConfig.getPayCompanyPublicKey());
        }
        context.setApiClientConfig(config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    protected ApiRequestModel buildApiRequestModel(JlBizRequest request, DefaultRequestContext context) {
        DefaultClientConfigModel configModel = context.getApiClientConfig();
        ApiRequestModel apiRequestModel = new ApiRequestModel();
        apiRequestModel.setApiURL(configModel.getApiParentURL() + context.getIApiDefinition().getApiURI());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json; charset=utf-8");
        headerMap.put("Accept", "application/json; charset=utf-8");
        headerMap.put("x-jlpay-appid", configModel.getAppId());
        String randomStr = NonceUtils.createNonce((int)32);
        String timestamp = String.valueOf(Instant.now().getEpochSecond());
        headerMap.put("x-jlpay-nonce", randomStr);
        headerMap.put("x-jlpay-timestamp", timestamp);
        headerMap.put("x-jlpay-sign-alg", "SM3WithSM2WithDer");
        apiRequestModel.setHeadMap(headerMap);
        apiRequestModel.setContentType("application/json; charset=utf-8");
        SerializeConfig config = new SerializeConfig();
        config.setPropertyNamingStrategy(PropertyNamingStrategy.SnakeCase);
        apiRequestModel.setRequestBody(JSONObject.toJSONString((Object)request, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]));
        return apiRequestModel;
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientName("\u5609\u8054");
        clientInfoModel.setClientCode("jlpay-sdk");
        return clientInfoModel;
    }

    protected JlBizResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        JSONObject resJson = JSONObject.parseObject((String)apiResponseModel.getResponseBody());
        return (JlBizResponse)resJson.toJavaObject(requestContext.getIApiDefinition().getResponseClass());
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        HttpRequest postRequest = HttpRequest.builder().url(HttpUtils.parseUrl((String)apiRequestModel.getApiURL())).headers(apiRequestModel.getHeadMap()).body(apiRequestModel.getRequestBody()).method(HttpMethod.POST).addHeader("x-jlpay-timestamp", String.valueOf(Instant.now().getEpochSecond())).addHeader("x-jlpay-nonce", NonceUtils.createNonce((int)32)).addHeader("x-jlpay-sign-alg", "SM3WithSM2WithDer").build();
        String sign = this.signVerifierManager.sign(postRequest);
        postRequest.addHeader("x-jlpay-sign", sign);
        HttpResponse httpResponse = this.sendPost(postRequest);
        ApiResponseModel responseModel = new ApiResponseModel();
        responseModel.setResponseBody(httpResponse.getBody());
        return responseModel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpResponse sendPost(HttpRequest httpRequest) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)httpRequest.getBody());
        Request request = new Request.Builder().url(httpRequest.getUrl()).headers(Headers.of((Map)httpRequest.getHeaders())).post(requestBody).build();
        OkHttpClient client2 = new OkHttpClient();
        try (Response response = client2.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new HttpStatusCodeException(response.code(), this.getBody(response));
            }
            HttpResponse httpResponse = this.buildHttpResponse(response);
            return httpResponse;
        }
        catch (IOException e) {
            throw new HttpExecutionException(String.format("Http Client execute failed, request: %s", httpRequest), (Throwable)e);
        }
    }

    private String getBody(Response response) throws IOException {
        return response.body() != null ? response.body().string() : null;
    }

    private HttpResponse buildHttpResponse(Response response) throws IOException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Headers headers = response.headers();
        for (String name : headers.names()) {
            headerMap.put(name, headers.get(name));
        }
        return HttpResponse.builder().headers(headerMap).body(this.getBody(response)).statusCode(response.code()).build();
    }
}

