/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.request.trade;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.hxb.request.HxbpayBizReq;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 获取银联userId
 *
 * @author
 * @version HxbUniouUserIdQueryReq.java, v 0.1 2024-02-28 17:21:05
 */
@Data
public class HxbUniouUserIdQueryReq extends HxbpayBizReq {

    private static final long serialVersionUID = -2213838555742663164L;


    /**
     * 商户流水号
     * 商户流水号
     * (选填)
     */
    @Length(max = 32, message = "orderNo长度不能超过32")
    private String orderNo;

    /**
     * 网络地址（终端IP）
     * 网络地址（终端IP），Ipv4格式：xx.xx.xx.xx Ipv6格式：xx:xx:xx:xx:xx:xx:xx:xx (注:1.Ipv6需转换为16进制;)
     * (选填)
     */
    private String occurAdd;

    /**
     * 交易设备GPS
     * 交易设备GPS
     * (选填)
     */
    @Length(max = 32, message = "GPS长度不能超过32")
    private String GPS;

    /**
     * 授权码
     * 付款方返回的临时授权码，一次有效
     * (选填)
     */
    @Length(max = 64, message = "userAuthCode长度不能超过64")
    private String userAuthCode;

    /**
     * 银联支付标识
     * 银联支付标识，收款方识别HTTP请求User Agent中包含银联支付标识，格式为“UnionPay/<版本号> <App标识>”，注意APP标识仅支持字母和数字。示例：UnionPay/1.0 ICBCeLife
     * (选填)
     */
    @Length(max = 64, message = "appUpIdentifier长度不能超过64")
    private String appUpIdentifier;

}