/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.request.trade;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.hxb.request.HxbpayBizReq;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 银联前台模式订单推送
 *
 * @author
 * @version HxbUniouOrderCreateReq.java, v 0.1 2024-02-28 17:38:21
 */
@Data
public class HxbUniouOrderCreateReq extends HxbpayBizReq {

    private static final long serialVersionUID = -2213838555161932515L;


    /**
     * 商户流水号
     * 商户流水号
     * (选填)
     */
    @Length(max = 32, message = "orderNo长度不能超过32")
    private String orderNo;

    /**
     * 订单金额
     * 订单金额，单位为元，精确到小数点后2位，例如：1.01,1.00
     * (选填)
     */
    @Length(max = 10, message = "amount长度不能超过10")
    private String amount;

    /**
     * 网络地址（终端IP）
     * 网络地址（终端IP），Ipv4格式：xx.xx.xx.xx Ipv6格式：xx:xx:xx:xx:xx:xx:xx:xx (注:1.Ipv6需转换为16进制;)
     * (选填)
     */
    private String occurAdd;

    /**
     * 交易设备GPS
     * 交易设备GPS
     * (选填)
     */
    @Length(max = 32, message = "GPS长度不能超过32")
    private String GPS;

    /**
     * 通知地址
     * 商户通知地址
     * (选填)
     */
    @Length(max = 200, message = "notifyUrl长度不能超过200")
    private String notifyUrl;

    /**
     * 终端类型
     * 终端类型，参考6.3设备类型数据字典，仅支持10-条码支付受理终端、11-条码支付辅助受理终端、13-MIS 终端
     * (选填)
     */
    @Length(max = 2, message = "terminalType长度不能超过2")
    private String terminalType;

    /**
     * 终端序列号
     * 终端序列号
     * (选填)
     */
    @Length(max = 50, message = "serialNum长度不能超过50")
    private String serialNum;

    /**
     * 终端编号
     * 终端编号，上送终端编号为已在我行系统注册的且终端状态启用，上送终端编号应与商户编号相互匹配
     * (选填)
     */
    @Length(max = 8, message = "terminalId长度不能超过8")
    private String terminalId;

    /**
     * 终端入网认证编号
     * 终端入网认证编号，由“中国银联标识产品企业资质认证办公室”通过入网认证的终端进行分配，格式：5 位字符，例如P3100
     * (选填)
     */
    @Length(max = 5, message = "networkLicense长度不能超过5")
    private String networkLicense;

    /**
     * 银联服务商机构标识码
     * 银联服务商机构标识码，银联分配的服务商机构标识码
     * (选填)
     */
    @Length(max = 11, message = "pnrInsIdCd长度不能超过11")
    private String pnrInsIdCd;

    /**
     * 借贷标识
     * 借贷标识，no_credit--指定不能使用信用卡支付
     * (选填)
     */
    @Length(max = 20, message = "limitPay长度不能超过20")
    private String limitPay;

    /**
     * 订单标题
     * 订单标题，即购买的商品名称
     * (选填)
     */
    @Length(max = 128, message = "subject长度不能超过128")
    private String subject;

    /**
     * 订单有效时间
     * 订单有效时间，单位为分钟，可上送范围：1-5区间的整数值，默认订单有效时间5分钟
     * (选填)
     */
    @Length(max = 10, message = "expireTime长度不能超过10")
    private String expireTime;

    /**
     * 持卡人IP
     * 持卡人确认付款时的IP地址，用于防钓鱼。需注意：无代理情况通过‘REMOTE_ADDR’获取IP地址，有代理情况通过‘REAL_IP’获取真实IP地址
     * (选填)
     */
    private String customerIp;

    /**
     * 失败交易前台通知地址
     * 失败交易前台通知地址，91-收款方向银联推送订单时上送的失败交易前台通知地址（仅允许为外网地址）APP侧未成功完成支付时调用，银联将通过GET方式访问本地址，银联将在frontFailUrl后附加付款中止原因码，原因码error_code取值如下：92-01-APP付款失败 93-用户取消支付
     * (选填)
     */
    @Length(max = 200, message = "frontFailUrl长度不能超过200")
    private String frontFailUrl;

    /**
     * 用户开放标识
     * 用户在APP上的标识号，用户信息获取应答码不等于34时必送
     * (选填)
     */
    @Length(max = 128, message = "userId长度不能超过128")
    private String userId;

    /**
     * 二维码类型
     * 二维码类型，主扫场景下二维码的类型，取值如下： 0-动态码 1-静态码 若为1-静态码，控制500限额
     * (选填)
     */
    @Length(max = 1, message = "qrCodeType长度不能超过1")
    private String qrCodeType;

    /**
     * 二维码
     * 二维码，商户上送行业码地址
     * ((必填))
     */
    @Length(max = 500, message = "qrCode长度不能超过500")
    private String qrCode;

    /**
     * 未成年支付控制
     * 未成年支付控制，1：限制，即该笔订单仅限成年人支付
     * (选填)
     */
    @Length(max = 1, message = "isAdult长度不能超过1")
    private String isAdult;

    /**
     * 用户授权码
     * 付款方返回的临时授权码，一次有效。
     * (必填)
     */
    @Length(max = 500, message = "userAuthCode长度不能超过500")
    private String userAuthCode;
}