/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.request.trade;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.hxb.request.HxbpayBizReq;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 条码支付-被扫
 *
 * @author
 * @version HxbScanCardCreateReq.java, v 0.1 2024-02-14 20:41:21
 */
@Data
public class HxbScanCardCreateReq extends HxbpayBizReq {

    private static final long serialVersionUID = -2213838555823429772L;


    /**
     * 商户流水号
     * 商户系统生成的订单流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "orderNo长度不能超过32")
    private String orderNo;

    /**
     * 授权码
     * 微信、支付宝、银联、数字人民币的付款码，格式见接口描述
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "authCode长度不能超过32")
    private String authCode;

    /**
     * 订单金额
     * 订单金额，单位为元，两位小数
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "amount长度不能超过10")
    private String amount;

    /**
     * 订单标题
     * 购买商品的订单标题
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "subject长度不能超过128")
    private String subject;

    /**
     * 订单描述
     * 订单的详细描述
     * (选填)
     */
    @Length(max = 256, message = "desc长度不能超过256")
    private String desc;

    /**
     * 终端编号
     * 已在系统注册的且状态启用的终端编号，与商户编号相互匹配
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

    /**
     * 银联-商品信息
     * 银联被扫交易时，商户可上送，详情参见要素说明
     * (选填)
     */
    @Length(max = 6000, message = "ylGoodsInfo长度不能超过6000")
    private String ylGoodsInfo;

    /**
     * 微信-订单优惠标记
     * 微信订单优惠标记，代金券或立减优惠功能的参数，详见微信官方说明
     * (选填)
     */
    @Length(max = 32, message = "goodsTag长度不能超过32")
    private String goodsTag;

    /**
     * 微信-单品列表
     * 微信单品优惠功能字段，详情参见要素说明
     * (选填)
     */
    @Length(max = 6000, message = "wxGoodsDetail长度不能超过6000")
    private String wxGoodsDetail;

    /**
     * 支付宝-可打折金额
     * 支付宝参与优惠计算的金额，详情参见要素说明
     * (选填)
     */
    @Length(max = 10, message = "aliDiscountableAmount长度不能超过10")
    private String aliDiscountableAmount;

    /**
     * 借贷标识
     * 指定不能使用信用卡支付，微信、支付宝、银联专用
     * (选填)
     */
    @Length(max = 20, message = "limitPay长度不能超过20")
    private String limitPay;

    /**
     * 订单有效时间
     * 指定订单的支付有效时间，超过有效时间用户将无法支付。单位为分钟，数字人民币交易范围为30-180秒
     * (选填)
     */
    @Length(max = 10, message = "expireTime长度不能超过10")
    private String expireTime;

    /**
     * 终端类型
     * 设备类型数据字典，支持10-条码支付受理终端、11-条码支付辅助受理终端、13-MIS 终端
     * (必填)
     */
    @NotBlank
    @Length(max = 2, message = "terminalType长度不能超过2")
    private String terminalType;

    /**
     * 终端序列号
     * 当终端类型为10时，终端序列号为必输，需与终端编号匹配
     * (选填)
     */
    @Length(max = 50, message = "serialNum长度不能超过50")
    private String serialNum;

    /**
     * 终端入网认证编号
     * 由中国银联标识产品企业资质认证办公室通过入网认证的终端分配的编号
     * (选填)
     */
    @Length(max = 5, message = "networkLicense长度不能超过5")
    private String networkLicense;

    /**
     * 网络地址（终端IP）
     * Ipv4或Ipv6格式的网络地址，数字人民币交易必输
     * (选填)
     */
    private String occurAdd;

    /**
     * 交易设备GPS
     * 与网络地址（终端IP）二选一必输，终端类型为10时，GPS必输
     * (选填)
     */
    @Length(max = 32, message = "GPS长度不能超过32")
    private String GPS;

    /**
     * 银联服务商机构标识码
     * 银联分配的服务商机构标识码
     * (选填)
     */
    @Length(max = 11, message = "pnrInsIdCd长度不能超过11")
    private String pnrInsIdCd;

    /**
     * 业务类型编码
     * 数字货币交易必输，参照6.4、6.6
     * (选填)
     */
    @Length(max = 4, message = "svcSysCode长度不能超过4")
    private String svcSysCode;

    /**
     * 业务种类编码
     * 数字货币交易必输，参照6.5、6.6
     * (选填)
     */
    @Length(max = 5, message = "busCtgty长度不能超过5")
    private String busCtgty;

    /**
     * 花呗分期数
     * 例：3（支付宝交易使用），仅支持传入3,6,12，其他期数暂不支持
     * (选填)
     */
    @Length(max = 5, message = "hbFqNum长度不能超过5")
    private String hbFqNum;

    /**
     * 使用花呗分期需要卖家承担的手续费比例
     * 百分值，传入100代表100%（支付宝交易使用），商家承担手续费传100，用户承担手续费传0。间联模式仅支持传0。
     * (选填)
     */
    @Length(max = 3, message = "hbFqSellerPercent长度不能超过3")
    private String hbFqSellerPercent;

    /**
     * 加密随机因子
     * 付款码后6位
     * (选填)
     */
    @Length(max = 6, message = "encryptRandNum长度不能超过6")
    private String encryptRandNum;

    /**
     * 终端硬件序列号密文数据
     * 仅在被扫支付类交易报文中出现，64bit的密文数据，对终端硬件序列号和加密随机因子（付款码后6位）加密后的结果；终端类型为10-条码支付受理终端时，该字段必输。
     * (选填)
     */
    @Length(max = 16, message = "secretText长度不能超过16")
    private String secretText;

}