/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.request.trade;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.hxb.request.HxbpayBizReq;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 主扫下单
 *
 * @author
 * @version HxbPreOrderCreateReq.java, v 0.1 2024-02-14 20:46:19
 */
@Data
public class HxbPreOrderCreateReq extends HxbpayBizReq {

    private static final long serialVersionUID = -2213838555267932099L;


    /**
     * 收款金额
     * 单位为元，两位小数
     * (选填)
     */
    @Length(max = 10, message = "amount长度不能超过10")
    private String amount;

    /**
     * 订单标题
     * 即购买的商品名称，不输入系统默认商户名称
     * (选填)
     */
    @Length(max = 128, message = "subject长度不能超过128")
    private String subject;

    /**
     * 商户流水号
     * 字段说明见3.1.9
     * (选填)
     */
    @Length(max = 32, message = "orderNo长度不能超过32")
    private String orderNo;

    /**
     * 通知地址
     * 最大长度不能超过200个字符
     * (选填)
     */
    @Length(max = 200, message = "notifyUrl长度不能超过200")
    private String notifyUrl;

    /**
     * 终端类型
     * 上送规则如下: 1.参考6.3设备类型数据字典，仅支持10-条码支付受理终端、11-条码支付辅助受理终端、13-MIS 终端; 2.上送未知终端类型则拒绝交易，并且上送终端类型需与终端编号匹配。
     * (选填)
     */
    @Length(max = 2, message = "terminalType长度不能超过2")
    private String terminalType;

    /**
     * 终端序列号
     * 上送规则如下: 1.当终端类型为10时，则终端序列号必输。 2.上送终端序列号需与上送的终端编号匹配关系正确。
     * (选填)
     */
    @Length(max = 50, message = "serialNum长度不能超过50")
    private String serialNum;

    /**
     * 终端编号
     * 上送规则如下: 1.上送终端编号为号已在我行系统注册的且终端状态启用，上送终端编号应与商户编号相互匹配。 2.不支持使用银行自有终端。
     * (选填)
     */
    @Length(max = 8, message = "terminalId长度不能超过8")
    private String terminalId;

    /**
     * 终端入网认证编号
     * 该编号由“中国银联标识产品企业资质认证办公室”通过入网认证的终端进行分配。 格式：5 位字符，例如P3100
     * (选填)
     */
    @Length(max = 5, message = "networkLicense长度不能超过5")
    private String networkLicense;

    /**
     * 网络地址（终端IP）
     * Ipv4格式：xx.xx.xx.xx Ipv6格式： xx:xx:xx:xx:xx:xx:xx:xx (注:1.Ipv6需转换为16进制; 2.若终端类型为10-条码支付受理终端时，网络地址（终端IP）、GPS和基站要求三选一上送。)
     * (选填)
     */
    private String occurAdd;

    /**
     * 交易设备GPS
     * 字段说明见3.1.12。 注:当终端类型为10-条码支付受理终端时，网络地址（终端IP）、GPS和基站要求三选一上送。
     * (选填)
     */
    @Length(max = 32, message = "GPS长度不能超过32")
    private String GPS;

    /**
     * 银联服务商机构标识码
     * 银联分配的服务商机构标识码
     * (选填)
     */
    @Length(max = 11, message = "pnrInsIdCd长度不能超过11")
    private String pnrInsIdCd;

    /**
     * 订单有效时间
     * 指定订单的支付有效时间，超过有效时间用户将无法支付。若不指定该参数则系统默认设置有效时间。 1.微信支付宝银联通道：参数允许设置范围：1-5区间的整数值。默认订单有效时间5分钟 。 2.数字人民币通道：该字段范围为30-180，单位为秒，若未上送则使用系统默认有效时间180秒。
     * (选填)
     */
    @Length(max = 10, message = "expireTime长度不能超过10")
    private String expireTime;

    /**
     * 借贷标识
     * no_credit--指定不能使用信用卡支付；
     * (选填)
     */
    @Length(max = 20, message = "limitPay长度不能超过20")
    private String limitPay;

    /**
     * 未成年支付控制
     * 1：限制，即该笔订单仅限成年人支付
     * (选填)
     */
    @Length(max = 1, message = "isAdult长度不能超过1")
    private String isAdult;

    /**
     * 二维码类型
     * 主扫场景下二维码的类型，取值如下：
     * 0-动态码
     * 1-静态码
     * 若为1-静态码，控制500限额
     * (选填)
     */
    @Length(max = 1, message = "qrCodeType长度不能超过1")
    private String qrCodeType;
}