/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.hxb.request.merchant;

import com.fshows.hxb.request.HxbpayBizReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author zhubo
 * @version HxbWxAppIdConfigReq.java, v 0.1 2024-02-20 10:21 zhubo
 */
@Data
public class HxbWxAppIdConfigReq extends HxbpayBizReq {
    private static final long serialVersionUID = 5129252190484784444L;

    /**
     * 系统流水号
     */
    private String systemNo;

    /**
     * 系统交易码
     */
    private String tranTrace;

    /**
     * 付款商户编号
     * 商户编号（HX开头的）
     */
    @Length(max = 32, message = "payMerchantNo长度不能超过32")
    private String payMerchantNo;

    /**
     * jsapi路径
     * 只支持新增，不支持修改和删除，单次交易只允许新增一个，最多5个
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;

    /**
     * 一级服务商编号
     */
    @Length(max = 20, message = "parentServerorgno长度不能超过20")
    private String parentServerorgno;
}
